#!/bin/bash

#############################################################
#
# 名  称：检查iptables打开后nf_conntrack_count 是否占nf_conntrack_max比例大于60%
# 错误码：
#  0001 网络配置可能不正确，最大连接数为0.
#  0002 nf_conntrack连接数比率大于60%
#############################################################
UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"
source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

checkItemId="74"
resultCode=0
errorKey=""
params=""
originalInfo=""

agentMonitorFile="/opt/dsware/agent/conf/agentMonitor"
NET_FILTER_CFG_PATH="/proc/sys/net/netfilter/"

##############################################################
## 检查是否为计算节点
##############################################################
function checkVBSNode()
{
    # 监控文件不存在
    if [ ! -f ${agentMonitorFile} ]
    then
        return 1
    fi

    local CNT_MONITOR=$(cat ${agentMonitorFile}  | grep vbs |grep -v alarm | grep -E "True" | wc -l)
    if [ "${CNT_MONITOR}" == "0" ]
    then
        # 当前节点没有VBS
        return 1
    fi

    return 0
}

main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
        log INFO "${checkItemId} do not select, pass"
        return 0
    fi

    # 检查是否为计算节点
    checkVBSNode
    ret=$?
    if [[ ${ret} -ne 0 ]];then
        originalInfo="No vbs is_mornitor=True in ${agentMonitorFile}. No need to check nf_conntrack."
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    # nf_conntrack_count与nf_conntrack_max不存在说明没有开启连接数监控，通过
    if [ ! -f ${NET_FILTER_CFG_PATH}nf_conntrack_count -o  ! -f ${NET_FILTER_CFG_PATH}nf_conntrack_max ]
    then
        log INFO "The firewall is not enabled and the nf_conntrack does not exist. Therefore, no check is required."
        originalInfo="The firewall is not enabled and the nf_conntrack does not exist. Therefore, no check is required."
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    nf_conntrack_count=$(cat ${NET_FILTER_CFG_PATH}nf_conntrack_count)
    nf_conntrack_max=$(cat ${NET_FILTER_CFG_PATH}nf_conntrack_max)
    if [ $nf_conntrack_max -eq 0 ]
    then
        log INFO "The ${NET_FILTER_CFG_PATH}nf_conntrack_max is 0."
        originalInfo="The ${NET_FILTER_CFG_PATH}nf_conntrack_max is 0."
        errorKey="${checkItemId}0001"  # 0001 网络配置可能不正确，最大连接数为0.
        resultCode=1
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    for((i=1;i<=5;i++));
    do
        process_nf=$(printf "%.2f" `echo "scale=2;${nf_conntrack_count}/${nf_conntrack_max}" | bc`)
        originalInfo=${originalInfo}"Result ${i}: ${nf_conntrack_count}/${nf_conntrack_max}=${process_nf}\n"
        if [ $(echo "${process_nf} >= 0.6" | bc) = 1 ]
        then
            log INFO "The nf_conntrack_count/nf_conntrack_max rate is greater than or equal to 60%."
            originalInfo=${originalInfo}"The nf_conntrack_count/nf_conntrack_max rate is greater than or equal to 60%.\n"
            errorKey="${checkItemId}0002"  # 0002 连接数比率大于60%
            resultCode=1
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 1
        fi
        sleep 5
        nf_conntrack_count=$(cat ${NET_FILTER_CFG_PATH}nf_conntrack_count)
        nf_conntrack_max=$(cat ${NET_FILTER_CFG_PATH}nf_conntrack_max)
    done

    originalInfo=${originalInfo}"All result is OK."
    log INFO "Check conntrack rate OK."
    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return 0
}

log MUST "enter [$0],para=[$@]"
main
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001 网络配置可能不正确，最大连接数为0.
#  0002 nf_conntrack连接数比率大于60%
##############################