#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

checkItemId="30"
resultCode=0
errorKey=""
params=""
originalInfo=""

main()
{

    local status=`cat /etc/opensm/opensm.conf | grep force_heavy_sweep | egrep -o -i false`
    originalInfo="command:cat /etc/opensm/opensm.conf | grep force_heavy_sweep\n"
    originalInfo="${originalInfo}""review:"`cat /etc/opensm/opensm.conf | grep force_heavy_sweep`"\n"
    if [[ -n ${status} ]]
    then
        originalInfo="${originalInfo}""result:openSM config:ok"
        log INFO "${checkItemId}:FSA_check_openSM_conf.sh:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    else
        resultCode=1
        errorKey="${checkItemId}0001"    #  0001 openSM配置不合法，/etc/opensm/opensm.conf 中的参数 force_heavy_sweep 设置不为FALSE
        originalInfo="${originalInfo}""result:force_heavy_sweep is TRUE."
        log ERROR "${checkItemId}FSA_check_openSM_conf.sh:force_heavy_sweep is TRUE."
        log ERROR "${checkItemId}:FSA_check_openSM_conf.sh:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001 openSM 配置不合法，/etc/opensm/opensm.conf 中的参数 force_heavy_sweep 设置不为FALSE
#
##############################