#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

checkItemId="47"
resultCode=0
errorKey=""
params=""
originalInfo=""

main()
{

    oracle_process_num=`ps -ef | grep -i -w oracle | grep -v grep | wc -l`
    originalInfo="command:ps -ef | grep -i -w oracle | grep -v grep | wc -l\n"
    originalInfo="${originalInfo}""review:${oracle_process_num}\n"

    if [ ${oracle_process_num} -eq 0 ]
    then 
        originalInfo="${originalInfo}""result:this server do not have oracle server."
        log INFO "${checkItemId}FSA_check_oracle:this server do not have oracle server."
        log INFO "${checkItemId}:FSA_check_oracle:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    else
        resultCode=1
        errorKey="${checkItemId}0001"  #  0001 服务器上有oracle服务
        originalInfo="${originalInfo}""result:this server have oracle server."
        log ERROR "${checkItemId}FSA_check_oracle:this server have oracle server."
        log ERROR "${checkItemId}:FSA_check_oracle:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001 服务器上有oracle服务
#
##############################