#!/bin/bash

cd $(dirname $0)
g_curPath="$PWD"
g_scriptName="$(basename $0)"
cd - >> /dev/null

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

#输出到json文件中的checkItemId,每个检查脚本一个id
checkItemId="39"
resultCode=0
errorKey=""
params=""
originalInfo=""

agentMonitorFile="/opt/dsware/agent/conf/agentMonitor"
dswareAgentTool="/opt/dsware/agent/tool/dsware_agent_tool"

function check_main()
{
    local CNT_MONITOR=$(cat ${agentMonitorFile}  | grep osd |grep -v alarm | grep -E "True" | wc -l)
    if [ "${CNT_MONITOR}" == "0" ]
    then
        originalInfo="No osd is_mornitor=True in ${agentMonitorFile}. No need to check osd process status."
        log INFO "${originalInfo}"
        return 0
    fi

    local CNT_OK_OSD_PROCESS=""
    declare -i count=0
    for temp in {1..3}
    do
        CNT_OK_OSD_PROCESS="$(${dswareAgentTool} --op query_process_info | grep -w "OSD" | grep -w "OK" | wc -l)"
        originalInfo="$(${dswareAgentTool} --op query_process_info | grep -w "OSD")"
        originalInfo="Monitor osd number is ${CNT_MONITOR} in ${agentMonitorFile};\n""command: ${dswareAgentTool} --op query_process_info | grep -w OSD""\n${originalInfo}"
        if [ "${CNT_OK_OSD_PROCESS}" -lt "${CNT_MONITOR}" ]
        then
            log ERROR "osd_status error: monitor_osd_num=[${CNT_MONITOR}], CNT_OK_OSD_PROCESS=[${CNT_OK_OSD_PROCESS}]."
            ((count++))
            if [ "${count}" -gt 1 ]
            then
                resultCode=1
                errorKey="390001"
            fi
        else
            break
        fi
        sleep 2
    done

    z_process_count=$(ps -e -o stat,cmd | grep -w "dsware_osd" | grep -v grep | awk '{print $1}' | grep -E "Z"  | wc -l)
    if [ "${z_process_count}" -ne "0" ]; then
        errorInfo="osd_status error: exist Z status osd process, z_process_count=[${z_process_count}]."
        log ERROR "${errorInfo}"
        resultCode=1
        errorKey="390001"
        originalInfo="${originalInfo}""\n${errorInfo}"
    fi

    d_process_count=$(ps -e -o stat,cmd | grep -w "dsware_osd" | grep -v grep | awk '{print $1}' | grep -E "D"  | wc -l)
    if [ "${d_process_count}" -ne "0" ]; then
        errorInfo="osd_status error: exist D status osd process, d_process_count=[${d_process_count}]."
        log ERROR "${errorInfo}"
        resultCode=1
        errorKey="390001"
        originalInfo="${originalInfo}""\n${errorInfo}"
    fi

    logInfo="Check osd process, monitor osd num:[${CNT_MONITOR}], running osd num:[${CNT_OK_OSD_PROCESS}]."
    log INFO "${logInfo}"
    originalInfo="${originalInfo}""\n${logInfo}"

    return "${resultCode}"
}

function main()
{
    check_main
    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return "${resultCode}"
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
