#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

checkItemId="49"
resultCode=0
errorKey=""
params=""
originalInfo=""

main()
{
    local agentMonitor="/opt/dsware/agent/conf/agentMonitor"
    local vbs_judg=`cat $agentMonitor | grep vbs|grep -v alarm | grep -E "True" | wc -l`    
    if [ ${vbs_judg} -eq 0 ]
    then
        originalInfo="result:this web_server is not VBS point."
        log INFO "This web_server is not VBS point."
        log INFO "${checkItemId}FSA_check_part_transport_key.sh:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi  

    review_of_key=`cat /opt/dsware/vbs/conf/vbs_*.cfg | grep part_of_transport_root_key`
    if [ $? -ne 0 ]
    then
        resultCode=2
        errorKey="${checkItemId}0002"    #  0002 系统中无/opt/dsware/vbs/conf/vbs_*.cfg
        originalInfo="command:grep part_of_transport_root_key /opt/dsware/vbs/conf/vbs_*.cfg\n"
        originalInfo="${originalInfo}""review:not found grep part_of_transport_root_key /opt/dsware/vbs/conf/vbs_*.cfg.\n"
        originalInfo="${originalInfo}""result:server not found grep part_of_transport_root_key /opt/dsware/vbs/conf/vbs_*.cfg."
        log ERROR "${checkItemId}FSA_check_part_transport_key.sh:server not found grep part_of_transport_root_key /opt/dsware/vbs/conf/vbs_*.cfg."
        log ERROR "${checkItemId}:FSA_check_part_transport_key.sh:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    else
        originalInfo="command:cat /opt/dsware/vbs/conf/vbs_*.cfg | grep part_of_transport_root_key\n"
        originalInfo="${originalInfo}""review:${review_of_key}\n"
        if [[ ${review_of_key}x == 'part_of_transport_root_key=abcdefghijklmn01'x ]]
        then
            originalInfo="${originalInfo}""result:transport key is right."
            log INFO "${checkItemId}FSA_check_part_transport_key.sh:transport key is right."
            log INFO "${checkItemId}FSA_check_part_transport_key.sh:ok"
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 0
        else
            resultCode=1
            errorKey="${checkItemId}0001"    #  0001 VBS配置文件中，传输密钥配置不正确
            originalInfo="${originalInfo}""result: transport secret key is wrong."
            log ERROR "${checkItemId}FSA_check_part_transport_key.sh:transport secret key is wrong."
            log ERROR "${checkItemId}:FSA_check_part_transport_key.sh:unok"
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 1
        fi
    fi

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001 VBS配置文件中，传输密钥配置不正确
#  0002 系统中无/opt/dsware/vbs/conf/vbs_*.cfg
#
##############################