#!/bin/bash
UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib/"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/error.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/error.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

# 临时文件列表
TMP_CHECK_OP_DIR="/tmp"
TMP_POOL_GPTVIEW=${TMP_CHECK_OP_DIR}/tmp_check_gptview_file
TMP_OSDTOPO_VIEW=${TMP_CHECK_OP_DIR}/tmp_check_osdtopo_file
TMP_SERVER_LIST=${TMP_CHECK_OP_DIR}/tmp_server_list_file
TMP_POOL_LIST=${TMP_CHECK_OP_DIR}/tmp_pool_list_file
TMP_SED_SH=${TMP_CHECK_OP_DIR}/tmp_replace_osd_as_server.sh

checkItemId="62"
resultCode=0
errorKey=""
params=""
originalInfo=""

IP_TYPE="ipv4"
NET_WORK_TYPE_FILE="/opt/dsware/agent/conf/network.cfg"
dsi_cmd=/opt/dsware/agent/tool/dsware_insight
mdc_url="0.0.0.0"
mdc_nid="0"
mdc_port="10530"

function getNetworkType()
{
    if [ ! -f ${NET_WORK_TYPE_FILE} ];then
        log "ERROR" "networkType file ${NET_WORK_TYPE_FILE} not exist!"
        return 1
    fi

    IP_TYPE=$(cat ${NET_WORK_TYPE_FILE} | grep -w -E "^storage_ipv6" | awk -F '=' '{print $2}')
    if [ "X0" != "X${IP_TYPE}" -a "X1" != "X${IP_TYPE}" ];then
        [[ -z "${IP_TYPE}" ]] && IP_TYPE="0" || { log ERROR "P_STORAGE_IP_FAMILY:${IP_TYPE} error!"; return 1; }
    fi

    if [ "X0" == "X${IP_TYPE}" ];then
        IP_TYPE="ipv4"
    elif [ "X1" == "X${IP_TYPE}" ];then
        IP_TYPE="ipv6"
    fi

    log INFO "current ip type: ${IP_TYPE}"

    return 0
}

function export_mdc_di_conf()
{
    getNetworkType
    ret=$?

    if [[ $ret -ne 0 ]];then
        return 1
    fi

    if [[ "${IP_TYPE}" == "ipv4" ]]; then
        # ipv4
        mdc_url=`cat /opt/dsware/mdc/conf/mdc_conf.cfg|grep mdc_url|awk -F '[ =@:,]+' '{print $3}'`
        mdc_nid=`cat /opt/dsware/mdc/conf/mdc_conf.cfg|grep mdc_url|awk -F '[ =@:,]+' '{print $2}'`
        mdc_port=`cat /opt/dsware/mdc/conf/mdc_conf.cfg|grep mdc_url|awk -F '[ =@:,]+' '{print $5}'`
    elif [[ "${IP_TYPE}" == "ipv6" ]]; then
        # ipv6
        mdc_url=`cat /opt/dsware/mdc/conf/mdc_conf.cfg|grep mdc_url|awk -F '[- =@,]+' '{print $3}'`
        mdc_nid=`cat /opt/dsware/mdc/conf/mdc_conf.cfg|grep mdc_url|awk -F '[- =@,]+' '{print $2}'`
        mdc_port=`cat /opt/dsware/mdc/conf/mdc_conf.cfg|grep mdc_url|awk -F '[- =@,]+' '{print $5}'`
    else
        log INFO "export_mdc_di_conf invaild ip type:${IP_TYPE}!"
        return 1
    fi
    return 0
}

function check_pool_secutiy()
{
    pool_id=$1
    mdc_security_level=`$dsi_cmd 0 $mdc_nid $mdc_url $mdc_port 8 172 $pool_id|grep mdc_security_level| awk -F '|' '{print $3}'|sed "s/ //g"`
    if [[ "$mdc_security_level" == "1" ]];
    then
        return 1
    elif [[ "$mdc_security_level" == "0" ]];
    then
        return 0
    fi
    log WARN "security level is disk. don't not to check."
    return 2
}

function check_pool_is_ec_pool()
{
    pool_id=$1
    pool_type=`$dsi_cmd 0 $mdc_nid $mdc_url $mdc_port 8 172 $pool_id|grep p_pool_redundancy_policy| awk -F '|' '{print $3}'|sed "s/ //g"`
    if [[ "${pool_type}" == "replication" ]];
    then
        return 0
    fi
    log WARN "pool:$pool_type do not check."
    return 1
}

function check_pool_safety_degrage()
{
    pool_id=$1

    check_pool_is_ec_pool $pool_id
    pool_type=$?
    if [[ ${pool_type} -eq 1 ]];
    then
        log WARN "ec pool not check."
        return 0
    fi

    check_pool_secutiy $pool_id
    secutiy=$?
    if [[ ${secutiy} -eq 2 ]];
    then
        return 0
    fi

    pass_flag=0
    $dsi_cmd 0 $mdc_nid $mdc_url $mdc_port 8 105 $pool_id > ${TMP_POOL_GPTVIEW}
    ret=$?; if [[ $ret -ne 0 ]]; then log ERROR "export pool gptview failed.";return 1 ;fi
    $dsi_cmd 0 $mdc_nid $mdc_url $mdc_port 8 101 $pool_id > ${TMP_OSDTOPO_VIEW}
    ret=$?; if [[ $ret -ne 0 ]]; then log ERROR "export osd topo view failed.";return 1 ;fi


    if [[ ${secutiy} -eq 1 ]];
    then
        cat ${TMP_OSDTOPO_VIEW} |tail -n +3|awk -F '|' -vptview_file="${TMP_POOL_GPTVIEW}" '{print  "sed -i \"s/"$3"/"$11"/g\" "ptview_file}' > ${TMP_SED_SH}
    else
        cat ${TMP_OSDTOPO_VIEW} |tail -n +3|awk -F '|' -vptview_file="${TMP_POOL_GPTVIEW}" '{print  "sed -i \"s/"$3"/"$9"/g\" "ptview_file}' > ${TMP_SED_SH}
    fi


    sed -i "s/\/[ ]*/\//g" ${TMP_SED_SH}
    sh ${TMP_SED_SH}
    if [[ ${secutiy} -eq 1 ]];
    then
        cat ${TMP_OSDTOPO_VIEW} |tail -n +3|awk -F '|' '{print $11}' |grep -o "[0-9]*"|sort |uniq > ${TMP_SERVER_LIST}
    else
        cat ${TMP_OSDTOPO_VIEW} |tail -n +3|awk -F '|' '{print $9}' |grep -o "[0-9]*"|sort |uniq > ${TMP_SERVER_LIST}
    fi

    while read line ;do
        number=`cat ${TMP_POOL_GPTVIEW} |grep -w "$line,$line"|wc -l`
        if [[ $number -gt 0 ]]; then
            pt_id=`cat ${TMP_POOL_GPTVIEW} |grep -w "$line,$line"|awk -F'|' '{print $2}'|awk -F'PARTITION' '{print $2}'`
            log "ERROR" "checked pt security failed,pt id:$pt_id";
            originalInfo="$originalInfo""checked pt security failed,pt id:$pt_id\n"
            pass_flag=1;
        fi;
    done < ${TMP_SERVER_LIST}
    while read line; do
        number=`cat ${TMP_POOL_GPTVIEW} | egrep -w "$line,[0-9]*,$line"|wc -l`
        if [[ $number -gt 0 ]]; then
            pt_id=`cat ${TMP_POOL_GPTVIEW} |egrep -w "$line,[0-9]*,$line"|awk -F'|' '{print $2}'|awk -F'PARTITION' '{print $2}'`
            log "ERROR" "checked pt security failed,pt id:$pt_id"
            originalInfo="$originalInfo""checked pt security failed,pt id:$pt_id\n"
            pass_flag=1;
        fi
    done < ${TMP_SERVER_LIST}
    if [ ${pass_flag} -eq 0 ] ;then
        log INFO "all pt security checked passed!!!"
    else
        log ERROR "some pt security checked failed!!!"
        return 2
    fi
    return 0
}

function check_remove_tmp_check_file()
{
    rm -f ${TMP_POOL_GPTVIEW}
    rm -f ${TMP_OSDTOPO_VIEW}
    rm -f ${TMP_SERVER_LIST}
    rm -f ${TMP_POOL_LIST}
    rm -f ${TMP_SED_SH}
}

function check_is_primary_mdc()
{
    local retry_times=20
    local sleep_time=5

    local count=0
    while true
    do
        if [[ $count -eq $retry_times ]];then
            break;
        fi
        master_mdc_info=`$dsi_cmd 0 $mdc_nid $mdc_url $mdc_port 8 100`
        test=`echo ${master_mdc_info}|grep -w -o "MASTER ID"`
        if [[ "${test}" != "" ]];then
            master_mdc_ip=`echo "${master_mdc_info}"|grep -v MASTER|awk -F '|' '{print $4}'|sed "s/ //g"`
            get_current_ip=`cat /opt/dsware/mdc/conf/mdc_conf.cfg |grep -w "^mdc_ip_2"|grep -w -o "${master_mdc_ip}"`
            if [[ "${get_current_ip}" == "" ]] ;
            then
                log INFO "not master mdc(${master_mdc_ip}), so exit."
                return 2
            else
                log INFO "master mdc, continue check."
                return 0
            fi
            break;
        fi

        sleep $sleep_time
        let count=count+1
    done
    return 1
}

function check_cluster_safety_degrage()
{
    export_mdc_di_conf
    ret=$?
    if [[ $ret -ne 0 ]];
    then
        resultCode=1
        errorKey=620001 ##加载MDC配置文件失败
        originalInfo="load mdc conf failed"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    # get all pool info
    degraded=0
    $dsi_cmd 0 $mdc_nid $mdc_url $mdc_port 8 165 -1|tail -n +2|awk -F '|' '{print $2}'|egrep -o "[0-9]*" > ${TMP_POOL_LIST}
    ret=$?;
    if [[ $ret -ne 0 ]]
    then
        log ERROR "get all pool info failed."
        resultCode=1
        errorKey=620002
        originalInfo="get all pool info failed"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi
    while read line;
    do
        pool_id=$line
        log INFO "check pool: ${pool_id} start!"
        originalInfo="$originalInfo""check pool: ${pool_id} start!\n"
        check_pool_safety_degrage $line
        ret=$?
        if [[ $ret -eq 1 ]];
        then
            log ERROR "exec pool:$pool_id script failed."
            originalInfo="$originalInfo""exec pool:$pool_id script failed\n"
            resultCode=1
            errorKey=620003
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 1

        elif [[ $ret -eq 2 ]];
        then
            log ERROR "check pool:$pool_id security degraded."
            originalInfo="$originalInfo""check pool:${pool_id} security degraded\n"
            degraded=1
        else
            log INFO "check pool:$pool_id security success."
        fi
    done < ${TMP_POOL_LIST}

    if [[ ${degraded} -eq 1 ]];
    then
        log ERROR "there exit some pool check security failed!"
        originalInfo="$originalInfo""there exit some pool check security failed!\n"
        resultCode=1
        errorKey=620004
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    else
        resultCode=0
        originalInfo="all pool check security success"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    fi
    log INFO "all pool check security success"

    return 0
}

main()
{
    local dsware_agent_tool="/opt/dsware/agent/tool/dsware_agent_tool"
    local agentMonitorFile="/opt/dsware/agent/conf/agentMonitor"
    log INFO "check BEGIN!!!"

	# only check on mdc node
    local CNT_MONITOR=$(cat ${agentMonitorFile} | grep mdc |grep -v alarm | grep -E "True" | wc -l)
    if [ "$CNT_MONITOR" -eq "0" ];
    then
        log INFO "only check on mdc node."
        log INFO "exit!"
        originalInfo="This node is not mdc node,no need to check"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    # only check on V100R006C30SPC501 and V100R006C30SPC500
    src_ver=`cat /opt/dsware/DSwareAgentNodeVersion|grep "nodeVersion"|awk -F'=' '{print $2}'`
    log INFO "current version: ${src_ver}"
    if [[ "${src_ver}" != "V100R006C30SPC501" && "${src_ver}" != "V100R006C30SPC500" ]];
    then
        log INFO "only check V100R006C30SPC501 and V100R006C30SPC500."
        log INFO "exit!"
        originalInfo="This version is ${src_ver},no need to check,only check V100R006C30SPC501 and V100R006C30SPC500"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    # degrage check
    check_cluster_safety_degrage
    ret=$?
    check_remove_tmp_check_file
    log INFO "check END!!!"
    return $ret
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  620001 加载MDC配置文件失败
#  620002 获取存储池信息失败
#  620003 执行脚本失败
#  620004 存在存储池处于degrage状态
#
#
##############################