#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

checkItemId="57"
resultCode=0
errorKey=""
params=""
originalInfo=""

main()
{
    server_code=`cat /proc/smio_info |grep -i RH2288H |grep -i V5`
    server=`cat /proc/smio_info`
    raid_num=`lspci |grep LSI -c`
    raid=`lspci |grep LSI`
    originalInfo="${originalInfo}""command:cat /proc/smio_info |grep -i RH2288H |grep -i V5; lspci |grep LSI -c; lspci |grep LSI \n"
    originalInfo="${originalInfo}""review:${server}; ${raid}; \n"
    if [[ -n "$server_code" ]] && [[ $raid_num == 2 ]] && [[ $raid =~ "3416" ]]
    then
        resultCode=1
        errorKey="${checkItemId}0001"    # 当前服务器是RH2288HV5,是双RAID卡，其中至少一张是SAS3416 RAID卡
        originalInfo="${originalInfo}""result:${server}; ${raid}; ."
        log ERROR "${checkItemId}FSA_check_raid:${server}; ${raid}; ."
        log ERROR "${checkItemId}:FSA_check_raid:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    else
        resultCode=0
        originalInfo="${originalInfo}""result:${server}; ${raid}; ."
        log INFO "${checkItemId}FSA_check_raid:${server}; ${raid}; ."
        log INFO "${checkItemId}:FSA_check_raid:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi
}

log MUST "enter [$0],para=[$@]"
main
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001  当前服务器是RH2288HV5,是双RAID卡，其中至少一张是SAS3416 RAID卡
#
##############################