#!/bin/bash

#############################################################
#
# 名  称：检查V100R006C10SPC300之前版本，VBS日志中是否存在读取锁
# 错误码：
#    巡检需要管控
#    0001 检查到有获取scsi3锁的日志
#############################################################
UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"
source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

checkItemId="73"
resultCode=0
errorKey=""
params=""
originalInfo=""

today_path=""
lastday_path=""
log_type="DSWARE"

agentMonitorFile="/opt/dsware/agent/conf/agentMonitor"
check_scsi3_log_tmp_path="/tmp/insp-${checkItemId}"

##############################################################
## 检查是否为计算节点
##############################################################
function checkVBSNode()
{
    # 监控文件不存在
    if [ ! -f ${agentMonitorFile} ]
    then
        return 1
    fi
    
    local CNT_MONITOR=$(cat ${agentMonitorFile}  | grep vbs |grep -v alarm | grep -E "True" | wc -l)
    if [ "${CNT_MONITOR}" == "0" ]
    then
        # 当前节点没有VBS
        return 1
    fi
    
    return 0
}

function get_log_type()
{
    local log_count=0
    # 检查是否是VRM转储日志，VRM日志保存在/var/backuplog/galaxenginelog/20210510/20210510-13.zip，需要解压zip
    local vrm_path="/var/backuplog/galaxenginelog/"`date "+%Y%m%d"`"/"
    if [ -d ${vrm_path} ]
    then
        # 检查是否存在日志 不存在继续向下检查
        log_count=`ls ${vrm_path} | wc -l`
        if [ ${log_count} -gt 0 ]
        then
            log_type="VRM"
            return 0
        fi
    fi

    # 检查CNA转储日志 FusionCompute版本为6.x及之后补丁版本
    local cna_path="/var/log/"`hostname`"/"`date "+%Y%m%d"`"/"
    if [ -d ${cna_path} ]
    then
        # 检查是否存在日志 不存在继续向下检查
        log_count=`ls ${cna_path} | wc -l`
        if [ ${log_count} -gt 0 ]
        then
          log_type="CNA_NEW"
          return 0
        fi
    fi

    # 检查CNA转储日志 FusionCompute版本为5.x及之前版本
    local cna_path_old="/var/log/"`hostname`"/"`date "+%d"`"/"
    if [ -d ${cna_path_old} ]
    then
        # 检查是否存在日志 不存在继续向下检查
        log_count=`ls ${cna_path_old} | wc -l`
        if [ ${log_count} -gt 0 ]
        then
          log_type="CNA_OLD"
          return 0
        fi
    fi

    # 不进行转储，为dsware
    log_type="DSWARE"
    return 0
}

# 检查vrm节点日志
function check_VRM_log()
{
    local vrm_path="/var/backuplog/galaxenginelog/"`date "+%Y%m%d"`"/"
    local log_zip=($(ls ${vrm_path}))

    # 1、把dsware日志解压到/tmp/FSA_check_scsi3/下
    mkdir -p ${check_scsi3_log_tmp_path}
    for log in ${log_zip[@]}
    do
        unzip -o ${vrm_path}${log} "dsware/*" -d ${check_scsi3_log_tmp_path}
    done

    # 2、检查解压后日志文件是否包含关键字
    local log_num=$(zgrep -a "VBP parse scsi op_code(0x5e)" ${check_scsi3_log_tmp_path}/dsware/* | grep -v grep | wc -l)
    originalInfo="${originalInfo}""command: zgrep -a 'VBP parse scsi op_code(0x5e)' ${check_scsi3_log_tmp_path}/dsware | grep -v grep | wc -l\n"
    originalInfo="${originalInfo}""Result: ${log_num}\n"

    # 3、删除解压后文件
    rm -rf $check_scsi3_log_tmp_path

    if [ ${log_num} -gt 0 ]
    then
        log INFO "${checkItemId} get scsi3_lock log"
        return 1
    fi
    return 0
}

function check_CNA_log()
{
    local cna_path=""

    if [ $log_type = "CNA_OLD" ]
    then
        # FusionCompute版本为5.x及之前版本
        cna_path="/var/log/"`hostname`"/"`date "+%d"`"/*/*"
    elif [ $log_type = "CNA_NEW" ]
    then
        # FusionCompute版本为6.x及之后补丁版本
        cna_path="/var/log/"`hostname`"/"`date "+%Y%m%d"`"/*/*"
    fi

    local log_num=$(zgrep -a "VBP parse scsi op_code(0x5e)" ${cna_path} | grep -v grep | wc -l)
    originalInfo="${originalInfo}""command: zgrep -a 'VBP parse scsi op_code(0x5e)' ${cna_path} | grep -v grep | wc -l\n"
    originalInfo="${originalInfo}""Result: ${log_num}\n"
    if [ ${log_num} -gt 0 ]
    then
        log INFO "${checkItemId} get scsi3_lock log"
        return 1
    fi

    return 0
}

function check_DSWARE_log()
{
    # 检查是否存在获取scsi3锁日志
    local tody_log=$(zgrep -a  "VBP parse scsi op_code(0x5e)" /var/log/dsware/dsware.`date "+%Y-%m-%d"`* | grep -v grep | wc -l)
    originalInfo="${originalInfo}""command: zgrep -a  'VBP parse scsi op_code(0x5e)' /var/log/dsware/dsware.`date '+%Y-%m-%d'`* | grep -v grep| wc -l\n"
    originalInfo="${originalInfo}""Result: ${tody_log}\n"
    if [ ${tody_log} -gt 0 ]
    then
        log INFO "${checkItemId} get VBP parse scsi op_code(0x5e) log"
        return 1
    fi

    return 0
}

function check_get_scsi3_lock_log()
{
    # 先检查当前日志是否存在scsi3锁日志
    local log_count=`grep -w "VBP parse scsi op_code(0x5e)" /var/log/dsware/dsware_agent.log | grep -v grep | wc -l`
    originalInfo="${originalInfo}""command: grep -w 'VBP parse scsi op_code(0x5e)' /var/log/dsware/dsware_agent.log | grep -v grep | wc -l\n"
    originalInfo="${originalInfo}""Result: ${log_count}\n"
    if [ ${log_count} -gt 0 ]
    then
        log INFO "${checkItemId} get VBP parse scsi op_code(0x5e) log"
        return 1
    fi

    ret=0
    if [ ${log_type} = "VRM" ]
    then
        # 检查VRM的日志
        check_VRM_log
        ret=$?
    elif [[ ${log_type} =~ "CNA" ]]
    then
        # 检查CNA的日志
        check_CNA_log
        ret=$?
    else
        # 检查DSWARE的日志
        check_DSWARE_log
        ret=$?
    fi

    return $ret
}

main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
        log INFO "${checkItemId} do not select, pass"
        return 0
    fi
    
    # 检查是否为计算节点
    checkVBSNode
    ret=$?
    if [[ ${ret} -ne 0 ]];then
        originalInfo="No vbs is_mornitor=True in ${agentMonitorFile}. No need to check scsi3_lock."
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    # 检查V100R006C10SPC300之前版本
    local version=$(cat /opt/dsware/DSwareAgentNodeVersion | grep -w "nodeVersion" |awk -F '=' '{print$2}')
    originalInfo="command: cat /opt/dsware/DSwareAgentNodeVersion | grep -w 'nodeVersion' |awk -F '=' '{print$2}'\nresult: ${version}\n"
    originalInfo="Result: ${version}\n"
    if [[ ${version} =~ V100R006C20 || ${version} =~ V100R006C30 || ${version} =~ V100R006C10SPC3 ]]
    then
        log INFO "The current version(${version}) is V100R006C30SPC300 or later. No need check scsi3 lock."
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    # 获取当前节点转储类型
    get_log_type
    log INFO "${checkItemId} this is ${log_type} node."

    # 检查节点日志
    check_get_scsi3_lock_log
    ret=$?
    if [[ ${ret} -ne 0 ]];then
        resultCode=1
        errorKey="${checkItemId}0001"
        log INFO "${checkItemId} get scsi3_lock log."
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    log INFO "Check scsi3-lock OK."
    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return 0
}

log MUST "enter [$0],para=[$@]"
main
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001 检查到有获取scsi3锁的日志
#
##############################