#!/bin/bash

cd $(dirname $0)
g_curPath="$PWD"
g_scriptName="$(basename $0)"
cd - >> /dev/null

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source  "/opt/dsware/agent/script/init_conf.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "/opt/dsware/agent/script/init_conf.sh failed."; exit 130; }

#输出到json文件中的checkItemId,每个检查脚本一个id
checkItemId="38"
resultCode=0
errorKey=""
params=""
originalInfo=""

agentMonitorFile="/opt/dsware/agent/conf/agentMonitor"
dswareAgentTool="/opt/dsware/agent/tool/dsware_agent_tool"

function check_main()
{
    local CNT_MONITOR=$(cat ${agentMonitorFile}  | grep osd |grep -v alarm | grep -E "True" | wc -l)
    if [ "${CNT_MONITOR}" == "0" ]
    then
        originalInfo="No osd is_mornitor=True in ${agentMonitorFile}. No need to check osd smio script."
        log INFO "${originalInfo}"
        return 0
    fi

    current_kernel=$(dsware_get_osd_kernel)
    scriptPath="/opt/dsware/osd/ko/"${current_kernel}"/smio"
    mainScriptStat=$(stat ${scriptPath}/smio_plugin_main.sh  |grep Modify |cut -c1-24)
    log INFO "the smio_plugin_main.sh modify time is ${mainScriptStat}"

    originalInfo="command: stat ${scriptPath}/smio_plugin_main.sh  |grep Modify |cut -c1-24 \n""${mainScriptStat}\n"

    error_info=""
    for file in ${scriptPath}/plugins_shell/*
    do
        if test -f $file
        then
            fileStat=$(stat $file | grep Modify | cut -c1-24)
            echo ${fileStat} |grep "${mainScriptStat}" >/dev/null
            if [ $? -ne 0 ]
            then
                log ERROR "$file  maybe changed! the modify time is ${fileStat}"
                originalInfo="${originalInfo}""command: stat $file |grep Modify |cut -c1-24 \n""${fileStat}. ERROR: This file maybe changed.\n"
                resultCode=1
                errorKey="380001"
            fi
        fi

        if test -d $file
        then
            log ERROR "$file is a directory"
            error_info="${error_info}""ERROR: $file is a directory \n"
        fi
    done

    if [[ -n "${error_info}" ]]
    then
        originalInfo="${originalInfo}""${error_info}"
        resultCode=1
        if [[ -z "${errorKey}" ]]
        then
            errorKey="380002"
        else
            errorKey="380003"
        fi
    fi

    return "${resultCode}"
}

function main()
{
    check_main
    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return "${resultCode}"
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
