#!/bin/bash

PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"
UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

checkItemId="32"
resultCode=0
errorKey=""
params=""
originalInfo=""

DSA_HANDLE="/opt/dsware/agent/script/dsware_agent_handle.sh"
NET_WORK_TYPE_FILE="/opt/dsware/agent/conf/network.cfg"
IP_TYPE=""


function getNetworkType()
{
    if [ ! -f ${NET_WORK_TYPE_FILE} ];then
        log ERROR "networkType file ${NET_WORK_TYPE_FILE} not exist!"
        return 1
    fi
    
    IP_TYPE=$(cat ${NET_WORK_TYPE_FILE} | grep -w -E "^storage_ipv6" | awk -F '=' '{print $2}')
    if [ "X0" != "X${IP_TYPE}" -a "X1" != "X${IP_TYPE}" ];then
        [[ -z "${IP_TYPE}" ]] && IP_TYPE="0" || { log ERROR "P_STORAGE_IP_FAMILY:${IP_TYPE} error!"; return 1; }
    fi

    if [ "X0" == "X${IP_TYPE}" ];then
        IP_TYPE="ipv4"
    elif [ "X1" == "X${IP_TYPE}" ];then
        IP_TYPE="ipv6"
    fi

    log INFO "P_STORAGE_IP_FAMILY=${IP_TYPE}"
    return 0
}


main()
{
    local version=`cat /opt/dsware/DSwareAgentNodeVersion|grep nodeVersion|awk -F '=' '{print $2}'`
    originalInfo="command:cat /opt/dsware/DSwareAgentNodeVersion|grep nodeVersion|awk -F '=' '{print \$2}'\n"
    originalInfo="${originalInfo}""review:nodeVersion=${version}\n"
    if [[ ! $version =~ "V100R006C" ]]
    then
        originalInfo="${originalInfo}""result:nodeVersion is not belong to R6.X."
        log INFO "${checkItemId}FSA_check_storage_ip:nodeVersion is not belong to R6.X."
        log INFO "${checkItemId}:FSA_check_storage_ip:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    getNetworkType
    if [ $? -ne 0 ]
    then
        resultCode=1
        errorKey="${checkItemId}0003"    #  003  无法获取存储节点IP地址类型
        originalInfo="${originalInfo}""result:can not get network_type."
        log ERROR "${checkItemId}FSA_check_storage_ip:can not get network_type."
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    local storage_ip_ret="$(sh "${DSA_HANDLE}" "inquiry_disk" "get_storage_ip")"
    log INFO "storage_ip_ret: ${storage_ip_ret}"
    local cmd_ret="$(echo "${storage_ip_ret}"|awk -F ';' '{print $1}' |awk -F '=' '{print $2}')"
    originalInfo="${originalInfo}""command:sh /opt/dsware/agent/script/dsware_agent_handle.sh inquiry_disk get_storage_ip | awk -F ';' '{print \$1}' |awk -F '=' '{print \$2}'\n"
    originalInfo="${originalInfo}""review:cmd_result=${cmd_ret}.\n"
    local current_node_IP=""
    if [ "Xipv4" == "X${IP_TYPE}" ];then
        current_node_IP="$(echo "${storage_ip_ret}"|awk -F ';' '{print $2}' |awk -F ':' '{print $2}')"
    else
        current_node_IP="$(echo "${storage_ip_ret}"|awk -F ';' '{print $2}' |awk -F ',' '{print $2}')"
    fi
    if [ "${cmd_ret}" != "0" ]
    then
        resultCode=1
        errorKey="${checkItemId}0002"    #  0002  使用 /opt/dsware/agent/script/dsware_agent_handle.sh 脚本获取存储 IP 失败。
        originalInfo="${originalInfo}""result:get storage_ip from ${DSA_HANDLE} failed."
        log ERROR "get storage_ip from ${DSA_HANDLE} failed."
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi
    

    originalInfo="${originalInfo}""command:sh /opt/dsware/agent/script/dsware_agent_handle.sh inquiry_disk get_storage_ip | awk -F ';' '{print \$2}' |awk -F ':' '{print \$2}'\n"
    originalInfo="${originalInfo}""review:current_node_IP=${current_node_IP}\n"
    local cluster_current_node_IP=`cat /opt/dsware/agent/conf/node_storage_ip | awk -F '=' '{print$2}'`
    originalInfo="${originalInfo}""command:cat /opt/dsware/agent/conf/node_storage_ip | awk -F '=' '{print\$2}'\n"
    originalInfo="${originalInfo}""review:cluster_current_node_IP=${cluster_current_node_IP}\n"

    if [[ ${current_node_IP} == ${cluster_current_node_IP} ]]
    then
        originalInfo="${originalInfo}""result:current_node_IP equal cluster_current_node_IP."
        log INFO "${checkItemId}:FSA_check_storage_ip:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    else
        resultCode=1
        errorKey="${checkItemId}0001"    #  0001 节点存储IP与操作系统实际存储IP不一致
        originalInfo="${originalInfo}""result:current_node_IP is not equal cluster_current_node_IP."
        log ERROR "${checkItemId}FSA_check_storage_ip:current_node_IP is not equal cluster_current_node_IP."
        log ERROR "${checkItemId}:FSA_check_storage_ip:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001 节点存储IP与操作系统实际存储IP不一致
#  0002 使用 /opt/dsware/agent/script/dsware_agent_handle.sh 脚本获取存储 IP 失败
#  0003 无法获取存储节点IP地址类型
#
##############################