#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools:/opt/dsware/agent/tool"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

checkItemId="26"
resultCode=0
errorKey=""
params=""
originalInfo=""

main()
{
    local version=`cat /opt/dsware/DSwareAgentNodeVersion|grep nodeVersion|awk -F '=' '{print $2}'`
    originalInfo="command:cat /opt/dsware/DSwareAgentNodeVersion|grep nodeVersion|awk -F '=' '{print \$2}'\n"
    originalInfo="${originalInfo}""review:nodeVersion=${version}\n"
    if [[ $version =~ "V100R006" ]]
    then
        originalInfo="${originalInfo}""result:FSA check third san:ok"
        log INFO "${checkItemId}:FSA_check_third_San:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi
    
    local proNum=`ps -ef | grep osd|grep -v grep|wc -l`
    originalInfo="${originalInfo}""command:ps -ef | grep osd|grep -v grep|wc -l\n"
    originalInfo="${originalInfo}""review:${proNum}"
    if [ $proNum -eq 0 ]
    then
        originalInfo="${originalInfo}""result:FSA check third san:ok"
        log INFO "${checkItemId}:FSA_check_third_San:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi
    
    local disk_num=`lsscsi |grep -v VBS|wc -l`
    originalInfo="${originalInfo}""command:lsscsi |grep -v VBS|wc -l\n"
    originalInfo="${originalInfo}""review:${disk_num}"
    if [ $disk_num -gt 64 ]
    then
        resultCode=1
        errorKey="${checkItemId}0001"    # 存储节点磁盘超过了64个
        originalInfo="${originalInfo}""result:storage node disks beyond 64"
        log ERROR "${checkItemId}FSA_check_third_San:storage node disks beyond 64"
        log ERROR "${checkItemId}:FSA_check_third_San:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    else
        originalInfo="${originalInfo}""result:FSA check third san:ok"
        log INFO "${checkItemId}:FSA_check_third_San:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001 存储节点磁盘超过了64个
#
##############################