#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

checkItemId="28"
resultCode=0
errorKey=""
params=""
originalInfo=""

main()
{

    local status='ok'
    tmp_info=""
    local vbs_version=`/opt/dsware/vbs/bin/dsware_vbs -v | grep -i version`
    tmp_info=`/opt/dsware/vbs/bin/dsware_vbs -v  2>&1`
    originalInfo="command:/opt/dsware/vbs/bin/dsware_vbs -v \n "
    originalInfo="${originalInfo}""review:`echo $tmp_info`\n"
    if [[ -z ${vbs_version} ]]
    then
        status='unok'
        error_vbs_num=1
        originalInfo="${originalInfo}""result:dsware_vbs third-prart package is wrong or binary files damaged  \n"
        log ERROR "${checkItemId}FSA_check_thrid_lib:dsware_vbs third-prart package is wrong."
    else
        error_vbs_num=0
    fi
    
    local osd_version=`/opt/dsware/osd/bin/dsware_osd -v | grep -i version`
    tmp_info=`/opt/dsware/osd/bin/dsware_osd -v  2>&1`
    originalInfo="${originalInfo}""command:/opt/dsware/osd/bin/dsware_osd -v \n"
    originalInfo="${originalInfo}""review:`echo $tmp_info`\n"
    if [[ -z ${osd_version} ]]
    then
        status='unok'
        error_osd_num=2
        originalInfo="${originalInfo}""result:dsware_osd third-prart package is wrong or binary files damaged\n"
        log ERROR "${checkItemId}FSA_check_thrid_lib:dsware_osd third-prart package is wrong."
    else
        error_osd_num=0
    fi

    local mdc_version=`/opt/dsware/mdc/bin/dsware_mdc -v | grep -i version`
    tmp_info=`/opt/dsware/mdc/bin/dsware_mdc -v  2>&1`
    originalInfo="${originalInfo}""command:/opt/dsware/mdc/bin/dsware_mdc -v \n"
    originalInfo="${originalInfo}""review:`echo $tmp_info`\n"
    if [[ -z ${mdc_version} ]]
    then
        status='unok'
        error_mdc_num=4
        originalInfo="${originalInfo}""result:dsware_mdc third-prart package is wrong or binary files damaged\n"
        log ERROR "${checkItemId}FSA_check_thrid_lib:dsware_mdc third-prart package is wrong."
    else
        error_mdc_num=0
    fi

    local agent_version=`/opt/dsware/agent/bin/dsware_agent -v | grep -i version`
    tmp_info=`/opt/dsware/agent/bin/dsware_agent -v  2>&1`
    originalInfo="${originalInfo}""command:/opt/dsware/agent/bin/dsware_agent -v \n"
    originalInfo="${originalInfo}""review:`echo $tmp_info`\n"
    if [[ -z ${agent_version} ]]
    then
        status='unok'
        error_agent_num=8
        originalInfo="${originalInfo}""result:dsware_agent third-prart package is wrong or binary files damaged\n"
        log ERROR "${checkItemId}FSA_check_thrid_lib:dsware_agent third-prart package is wrong."
    else
        error_agent_num=0
    fi

    if [[ ${status} == "ok" ]]
    then
        originalInfo="${originalInfo}""result:FSA check third lib is ok."
        log INFO "${checkItemId}:FSA_check_thrid_lib:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    else
        resultCode=1
        originalInfo="${originalInfo}""result:FSA check third lib is unok."
        error_num_total=$[${error_vbs_num}+${error_mdc_num}+${error_osd_num}+${error_agent_num}]
        errorKey="${checkItemId}0000"
        errorKey=$[${errorKey}+${error_num_total}]
        log ERROR "${checkItemId}:FSA_check_thrid_lib:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}



##############################
#
#  错误码：
#  0001 dsware_vbs                                       第三方包存在问题
#  0002 dsware_osd                                       第三方包存在问题
#  0003 dsware_vbs,dsware_osd                            第三方包存在问题
#  0004 dsware_mdc                                       第三方包存在问题
#  0005 dsware_mdc,dsware_vbs                            第三方包存在问题
#  0006 dsware_mdc,dsware_osd                            第三方包存在问题
#  0007 dsware_mdc,dsware_osd,dsware_vbs                 第三方包存在问题
#  0008 dsware_agent                                     第三方包存在问题
#  0009 dsware_agent,dsware_vbs                          第三方包存在问题
#  0010 dsware_agent,dsware_osd                          第三方包存在问题
#  0011 dsware_agent,dsware_osd,dsware_vbs               第三方包存在问题
#  0012 dsware_agent,dsware_mdc                          第三方包存在问题
#  0013 dsware_agent,dsware_mdc,dsware_vbs               第三方包存在问题
#  0014 dsware_agent,dsware_mdc,dsware_osd               第三方包存在问题
#  0015 dsware_agent,dsware_mdc,dsware_osd,dsware_vbs    第三方包存在问题
#
##############################