#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="70"
resultCode=0
errorKey=""
params=""
originalInfo=""

dsi_cmd=/opt/dsware/agent/tool/dsware_insight
NET_WORK_TYPE_FILE="/opt/dsware/agent/conf/network.cfg"
IP_TYPE="ipv4"
mdc_url="0.0.0.0"
mdc_nid="0"
mdc_port="10530"
tmpRes="/tmp/result"

function getNetworkType()
{
    if [ ! -f ${NET_WORK_TYPE_FILE} ];then
        return 0
    fi

    IP_TYPE=$(cat ${NET_WORK_TYPE_FILE} | grep -w -E "^storage_ipv6" | awk -F '=' '{print $2}')

    if [ "X1" == "X${IP_TYPE}" ];then
        IP_TYPE="ipv6"
    else
        IP_TYPE="ipv4"
    fi

    log INFO "current ip type: ${IP_TYPE}"

    return 0
}

function export_mdc_di_conf()
{
    getNetworkType

    if [[ "${IP_TYPE}" == "ipv4" ]]; then
        # ipv4
        mdc_url=`cat /opt/dsware/mdc/conf/mdc_conf.cfg|grep mdc_url|awk -F '[ =@:,]+' '{print $3}'`
        mdc_nid=`cat /opt/dsware/mdc/conf/mdc_conf.cfg|grep mdc_url|awk -F '[ =@:,]+' '{print $2}'`
        mdc_port=`cat /opt/dsware/mdc/conf/mdc_conf.cfg|grep mdc_url|awk -F '[ =@:,]+' '{print $5}'`
    else
        # ipv6
        mdc_url=`cat /opt/dsware/mdc/conf/mdc_conf.cfg|grep mdc_url|awk -F '[- =@,]+' '{print $3}'`
        mdc_nid=`cat /opt/dsware/mdc/conf/mdc_conf.cfg|grep mdc_url|awk -F '[- =@,]+' '{print $2}'`
        mdc_port=`cat /opt/dsware/mdc/conf/mdc_conf.cfg|grep mdc_url|awk -F '[- =@,]+' '{print $5}'`
    fi
    return 0
}

function check_vbs_metadata_version()
{
    #全局元数据卷迁移后升级，存在风险。
    pool_id=$1
    
    if [ -f /tmp/*getVbsMetaVersion*.txt ]
    then
        rm -f /tmp/*getVbsMetaVersion*.txt
    fi
    
    #备份元数据文件
    #需要判断pt_flat版本号，136命令在升级前默认为单pt，没有这个pt_flag参数；升级到V100R006C30SPC200及之后，默认为多pt为0，需要指定为1查询单pt
    pt_flag=
    #获取源版本为V100R006C30SPC200及以后版本，需要指定为备份单pt
    src_version="$(get_src_version)"
    log INFO "src_version = ${src_version}"
    if [[ ${src_version} =~ V100R006C30SPC2 || ${src_version} =~ V100R006C30SPC3 || ${src_version} =~ V100R006C30SPC5 || ${src_version} =~ V100R006C30SPC6 || ${src_version} =~ V100R006C30SPC8 || ${src_version} =~ V100R006C30SPC9 || ${src_version} =~ V100R006C30SPH ]]
    then
        pt_flag=1
    fi
    
    exec 6>&1
    exec >/tmp/result
    
    /usr/bin/expect <<-EOF
    set timeout 10
    spawn $dsi_cmd 0 $mdc_nid $mdc_url $mdc_port 8 136 $pool_id -33 2146435072 512 0 0 getVbsMetaVersion /tmp $pt_flag
    expect "Yes/No" {send "Yes\r"}
    expect eof
EOF
    exec 1>&6 6>&-
    #判断all key not found,代表没查询到元数据版本信息，正常退出
    if [ -n "$(cat /tmp/result | grep 'all key not found')" ]
    then
        #没有发生过迁移，该节点没有全局元数据
        log INFO "Pool ${pool_id} is not have VBS Metadata Volume."
        return 0
    fi
    
    if [ ! -f /tmp/*getVbsMetaVersion*.txt ]
    then
        log ERROR "VBS Metadata Volume Backup Fails and Whether the Volume Has Been Migrated Cannot Be Determined, Causing Upgrade Risks."
        log ERROR "exit!"
        originalInfo="command: $dsi_cmd 0 $mdc_nid $mdc_url $mdc_port 8 136 $pool_id -33 2146435072 512 0 0 getVbsMetaVersion /tmp/  Failed.\n "
        resultCode=1
        errorKey="${checkItemId}0001"
        return 1
    fi
    
    version=`cat /tmp/*getVbsMetaVersion*.txt | grep -w meta_ver`
    if [ -n "${version}" ]
    then
        log ERROR "The global metadata volume being migrated , causing risks.meta_ver: ${version}"
        log ERROR "exit!"
        originalInfo="command: $dsi_cmd 0 $mdc_nid $mdc_url $mdc_port 8 136 $pool_id -33 2146435072 512 0 0 getVbsMetaVersion /tmp/;cat /tmp/getVbsMetaVersion.txt | grep meta_ver  Sucessed."
        originalInfo="${originalInfo}""The global metadata volume has been migrated before, which may cause upgrade risks.\n metaData Vetrsion : ${version}"
        resultCode=1
        errorKey="${checkItemId}0002"
        rm -f /tmp/*getVbsMetaVersion*.txt
        return 1
    fi
    
    rm -f /tmp/*getVbsMetaVersion*.txt
    return 0
}

function main()
{
    # only check on mdc node
    local agentMonitorFile="/opt/dsware/agent/conf/agentMonitor"
    local CNT_MONITOR=$(cat ${agentMonitorFile} | grep mdc |grep -v alarm | grep -E "True" | wc -l)
    if [ "$CNT_MONITOR" -eq "0" ]
    then
        log INFO "only check on mdc node."
        log INFO "exit!"
        originalInfo="This node is not mdc node,no need to check."
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi
    
    #导入di配置
    export_mdc_di_conf
    
    #查询存储池个数
    $dsi_cmd 0 $mdc_nid $mdc_url $mdc_port 8 165 -1 >$tmpRes
    ret=$?
    #查询所有池命令错误，报错
    if [[ ${ret} -ne 0 ]]
    then
        log ERROR "Query pool num error! command: $dsi_cmd 0 $mdc_nid $mdc_url $mdc_port 8 165 -1"
        log ERROR "exit!"
        originalInfo="Query pool num error! command: $dsi_cmd 0 $mdc_nid $mdc_url $mdc_port 8 165 -1 exec Error."
        resultCode=1
        errorKey="${checkItemId}0003"
        rm -f $tmpRes
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi
    #将查询结果转换为数组
    local poolArray=(`cat ${tmpRes} | sed '1d' | awk -F '|' '{print $2}'| awk -F ' ' '{print $2}'`)
    log INFO "all pool:${poolArray[@]}; pool number ${#poolArray[@]}"
    if [[ ${#poolArray[@]} -lt 3 ]]
    then
        log INFO "pool number less 3."
        log INFO "exit!"
        originalInfo="This pool num less than 3."
        rm -f $tmpRes
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi
    rm -f $tmpRes
    
    #查询元数据池
    $dsi_cmd 0 $mdc_nid $mdc_url $mdc_port 8 167 >$tmpRes
    ret=$?
    #查询元数据池命令错误，报错
    if [[ ${ret} -ne 0 ]]
    then
        log ERROR "Query Metadata pool error! command: $dsi_cmd 0 $mdc_nid $mdc_url $mdc_port 8 167"
        log ERROR "exit!"
        originalInfo="Query Metadata pool error! command: $dsi_cmd 0 $mdc_nid $mdc_url $mdc_port 8 167 exec Error."
        resultCode=1
        errorKey="${checkItemId}0004"
        rm -f $tmpRes
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi
    
    local metaDataPool=(`cat $tmpRes | sed '1,3d' | awk -F '|' '{print $2}'| awk -F ' ' '{print $2}'`)
    log INFO "metaDataPool:${metaDataPool[@]}; metaDataPool number ${#metaDataPool[@]}"
    rm -f $tmpRes
    
    #开始匹配当前不存在全局元数据卷的池，查找是否存在之前的迁移痕迹
    for pool_id in ${poolArray[@]}
    do
        flag=0
        for metaData_pool_id in ${metaDataPool[@]}
        do
            if [[ $pool_id -eq $metaData_pool_id ]]
            then
                flag=1
                break;
            fi
        done
        
        if [[ flag -eq 1 ]]
        then
            continue
        fi
        
        #开始备份元数据查找元数据version
        check_vbs_metadata_version ${pool_id}
        ret=$?
        if [[ ${ret} -ne 0 ]]
        then
            #开始报错
            log INFO "check END!!!"
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 1
        fi
    done
    
    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    log INFO "check END!!!"
    return 0
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001 VBS Metadata Volume Backup Fails and Whether the Volume Has Been Migrated Cannot Be Determined, Causing Upgrade Risks.
#  0002 The global metadata volume being migrated , causing risks.
#
##############################
