#!/bin/bash

cd $(dirname $0)
g_curPath="$PWD"
g_scriptName="$(basename $0)"
cd - >> /dev/null

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

#输出到json文件中的checkItemId,每个检查脚本一个id
checkItemId="36"
resultCode=0
errorKey=""
params=""
originalInfo=""

zk_path="/opt/dsware/agent/zk/"
agentMonitorFile="/opt/dsware/agent/conf/agentMonitor"

function check_main()
{
    local NUM_ZK=$(cat ${agentMonitorFile} | grep zk |grep -v alarm | grep -E "True" | wc -l)

    if [ "$NUM_ZK" == "0" ]
    then
        originalInfo="No zk_is_mornitor=True in ${agentMonitorFile}, no need to check."
        log INFO "${originalInfo}"
        return 0
    fi

    #判断zk进程是否存在：有ZK监控，但没有ZK进程，则检查不合格
    ps -efww|grep zookeeper|grep Dzookeeper.log.dir |grep ${zk_path} |grep -v grep >/dev/null 2>&1
    if [ 0 -ne $? ]
    then
        log ERROR "zk node, but zk progress not exist."
        originalInfo="command: ps -efww|grep zookeeper|grep Dzookeeper.log.dir |grep ${zk_path} |grep -v grep \n""ERROR: zk node, but zk progress not exist."
        resultCode=1
        errorKey="360001"
        return 1
    fi

    #检测zk与其它几个zk进程之间是否正常
    cd /opt/dsware/agent/zk/bin/
    check_ret=$(sh zkStatus.sh)
    cd - >>/dev/null
    tmp=$(echo "${check_ret}"| grep -i Mode |grep -i -E 'leader|follower|observer')

    originalInfo="command: cd /opt/dsware/agent/zk/bin/; sh zkStatus.sh\n""${check_ret}\n"

    if [ -z "${tmp}" ]
    then
        log ERROR "zk_status Error: not leader or follower or observer."
        originalInfo="${originalInfo}""zk_status Error: not leader or follower or observer.\n"
        resultCode=1
        errorKey="360001"
    fi

    z_process_count=$(ps -e -o stat,cmd | grep -w "zookeeper" | grep "${zk_path}" | grep -v grep | awk '{print $1}' | grep -E "Z" | wc -l)
    if [ "${z_process_count}" -ne "0" ]; then
        errorInfo="zk_status error: exist Z status zk process, z_process_count=[${z_process_count}]."
        log ERROR "${errorInfo}"
        originalInfo="${originalInfo}""${errorInfo}\n"
        resultCode=1
        errorKey="360001"
    fi

    d_process_count=$(ps -e -o stat,cmd | grep -w "zookeeper" | grep "${zk_path}" | grep -v grep | awk '{print $1}' | grep -E "D" | wc -l)
    if [ "${d_process_count}" -ne "0" ]; then
        errorInfo="zk_status error: exist D status zk process, d_process_count=[${z_process_count}]."
        log ERROR "${errorInfo}"
        originalInfo="${originalInfo}""${errorInfo}\n"
        resultCode=1
        errorKey="360001"
    fi

    return 0
}

function main()
{
    check_main
    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return "${resultCode}"
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}