#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }


checkItemId="37"
resultCode=0
errorKey=""
params=""
originalInfo=""

main()
{
    update_version=$(get_package_version)
    if [[ ! ${update_version} =~ "R006C30SPC500" || ! ${update_version} =~ "R006C30SPC501" || ! ${update_version} =~ "R006C30SPC300" ]]
    then
        originalInfo="result:target update version not belong to R006C30SPC500 or R006C30SPC501 or R006C30SPC300."
        log INFO "${checkItemId}FSA_check_zk_cfg.sh:target update version not belong to R006C30SPC500 or R006C30SPC501 or R006C30SPC300."
        log INFO "${checkItemId}:FSA_check_zk_cfg.sh:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    if [ ! -f /opt/dsware/agent/zk/data/myid ]
    then
        originalInfo="command:ls /opt/dsware/agent/zk/data/myid\n"
        originalInfo="${originalInfo}""review:\$? not equal 0.\n"
        originalInfo="${originalInfo}""result:/opt/dsware/agent/zk/data/myid not fonud."
        log INFO "${checkItemId}FSA_check_zk_cfg.sh:/opt/dsware/agent/zk/data/myid not fonud."
        log INFO "${checkItemId}:FSA_check_zk_cfg.sh:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    local zoo_cfg="/opt/dsware/agent/zk/conf/zoo.cfg"
    local myid="/opt/dsware/agent/zk/data/myid"
    local id="$(cat "${myid}")"
    originalInfo="command:cat ${myid}\n"
    originalInfo="${originalInfo}""review:${id}\n"
    local zkNum=`cat "${zoo_cfg}" | grep server.${id} -c`
    originalInfo="${originalInfo}""command:cat ${zoo_cfg} | grep server.${id} -c\n"
    originalInfo="${originalInfo}""review:${zkNum}\n"
    
    if [ $zkNum -gt 1 ]
    then
        resultCode=1
        errorKey="${checkItemId}0001"    #  0001 ZK 数量超过了1个
        originalInfo="${originalInfo}""result:ZK nums beyond 1."
        log ERROR "${checkItemId}FSA_check_zk_cfg.sh:ZK nums beyond 1."
        log ERROR "${checkItemId}:FSA_check_zk_cfg.sh:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    else
        originalInfo="${originalInfo}""result:ZK nums not beyond 1."
        log INFO "${checkItemId}FSA_check_zk_cfg.sh:ZK nums not beyond 1."
        log INFO "${checkItemId}:FSA_check_zk_cfg.sh:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi 

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001 ZK 数量超过了 1 个
#
##############################