#!/bin/bash

cd $(dirname $0)
g_curPath="$PWD"
g_scriptName="$(basename $0)"
cd - >> /dev/null

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

#输出到json文件中的checkItemId,每个检查脚本一个id
checkItemId="34"
resultCode=0
errorKey=""
params=""
originalInfo=""

srcVersion="$(get_src_version)"
targetVersion="$(get_package_version)"
zk_path="/opt/dsware/agent/zk/"
agentMonitorFile="/opt/dsware/agent/conf/agentMonitor"

function check_main()
{
    if [[ $srcVersion == V100R006C30SP[CH][2-4]0* || "${targetVersion}" == V100R006C30SP[CH][2-5]* ]]
    then
        log INFO "Current version is ${srcVersion}, target Version is ${targetVersion}, begin to check node zk process with mdc process."
    else
        originalInfo="Current version is ${srcVersion}, target Version is ${targetVersion}, no need to check zk with mdc process."
        log INFO "${originalInfo}"
        return 0
    fi

    local NUM_ZK=$(cat ${agentMonitorFile} | grep zk |grep -v alarm | grep -E "True" | wc -l)

    if [ "$NUM_ZK" == "0" ]
    then
        originalInfo="No zk_is_mornitor=True in ${agentMonitorFile}, no need to check."
        log INFO "${originalInfo}"
        zk_processs_command="command:ps -efww|grep zookeeper|grep Dzookeeper.log.dir |grep ${zk_path} |grep -v grep"
        zk_processs_ret=$(ps -efww|grep zookeeper|grep Dzookeeper.log.dir |grep ${zk_path} |grep -v grep)
        originalInfo="${originalInfo}\n""${zk_processs_command}\n""review:${zk_processs_ret}\n"
        return 0
    fi

    #有ZK进程存在，则检查是否有MDC监控，若没有MDC进程监控则表明没有MDC进程，检查不合格
    local CNT_MONITOR=$(cat ${agentMonitorFile} | grep mdc |grep -v alarm | grep -E "True" | wc -l)
    if [ ${CNT_MONITOR} == "0" ]
    then
        log ERROR "ERROR:ZK Process exists, but no mdc is_mornitor=True is in ${agentMonitorFile}."
        originalInfo="${originalInfo}""command: cat ${agentMonitorFile} | grep mdc |grep -v alarm | grep -E True \n""ERROR:ZK Process exist, but no mdc_is_mornitor=True is in ${agentMonitorFile}, no mdc process exist."
        resultCode=1
        errorKey="340001"
        return 1
    fi

    #检查MDC进程状态
    local dsware_agent_tool="/opt/dsware/agent/tool/dsware_agent_tool"
    CNT_OK_MDC_PROCESS="$(${dsware_agent_tool} --op query_process_info | grep -w "MDC" | grep -w "OK" | wc -l)"
    if [ ${CNT_OK_MDC_PROCESS} -lt ${CNT_MONITOR} ]
    then
        log ERROR "mdc_status error: monitor_mdc_num:${CNT_MONITOR}, running mdc num:${CNT_OK_MDC_PROCESS}."
        originalInfo="${originalInfo}""command: ${dsware_agent_tool} --op query_process_info | grep -w MDC | grep -w OK \n""ERROR: monitor mdc num:[${CNT_MONITOR}], running mdc num:[${CNT_OK_MDC_PROCESS}]."
        resultCode=1
        errorKey="340001"
        return 1
    fi

    zk_processs_command="ps -efww|grep zookeeper|grep Dzookeeper.log.dir |grep ${zk_path} |grep -v grep"
    zk_processs_ret=$(ps -efww|grep zookeeper|grep Dzookeeper.log.dir |grep ${zk_path} |grep -v grep)

    mdc_process_command="${dsware_agent_tool} --op query_process_info | grep -w MDC"
    mdc_process_ret=$(${dsware_agent_tool} --op query_process_info | grep -w MDC)

    originalInfo="command: ${zk_processs_command}\n""${zk_processs_ret}\n""command: ${mdc_process_command}\n""${mdc_process_ret}\n"
    return 0
}

function main()
{
    check_main
    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return "${resultCode}"
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}