#!/bin/bash

#############################################################
#
# 名  称：检查网关信息是否正确
# 错误码：
#         0000 正常
#         0001 网关信息没有配置
#         0002 网关信息配置不一致
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="1105"
resultCode=0
errorKey=""
params=""
originalInfo=""

manageLocalIpFile="/opt/omm/oms/workspace/ha/module/harm/plugin/conf/DSMmanagerLocalIp.xml"

function main()
{
    manager_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
       log INFO "${checkItemId} do not select, pass"
       return 0
    fi

    manager_gateway=`cat ${manageLocalIpFile} | grep manager_gateway | awk -F '\"' '{print $6}'`
    originalInfo="${originalInfo}""command:cat $manageLocalIpFile | grep manager_gateway\n"
    originalInfo="${originalInfo}""result:${manager_gateway}\n"
    if [[ -z ${manager_gateway} ]] ;then
        resultCode=1
        errorKey="${checkItemId}0001"   # 网关信息未配置
        originalInfo="${originalInfo}""\n result:Gateway is not configure."
        log ERROR "Gateway is not configure."
        log ERROR "FSM_${checkItemId}:unok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    server_current_gateway_num=`netstat -rn | grep ${manager_gateway} | wc -l 2> /dev/null`
    originalInfo="${originalInfo}""command:netstat -rn\n"
    local server_current_gateway=`netstat -rn | grep UG | awk '{print $2}'`
    originalInfo="${originalInfo}""result:${server_current_gateway}\n"
    if [ ${server_current_gateway_num} -eq 0 ];then
        resultCode=1
        errorKey="${checkItemId}0002"   # 网关信息配置不一致
        originalInfo="${originalInfo}""\n result:Gateway configure different."
        log ERROR "Gateway configure error."
        log ERROR "FSM_${checkItemId}:unok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    else
        originalInfo="${originalInfo}""result:Gateway configure correct.\n"
        log INFO "FSM_${checkItemId}:this Gateway configure correct."
        log INFO "FSM_${checkItemId}:ok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}


