#!/bin/bash

#############################################################
#
# 名  称：检查/opt目录剩余空间
# 错误码：
#         0000 正常
#         0001 内存未查到
#         0002 剩余内存不足10G
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="1106"
resultCode=0
errorKey=""
params=""
originalInfo=""

function main()
{
    manager_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
       log INFO "${checkItemId} do not select, pass"
       return 0
    fi

    local free_memory=`df -B1m /opt/update 2> /dev/null | sed -n '$p' | awk '{print $(NF-2)}'`
    min_memory="14336"    #理论/opt目录剩余最小空间14G=14336MB

    originalInfo="${originalInfo}""command:df -B1m /opt/update 2> /dev/null | sed -n '\$p' | awk '{print \$(NF-2)}'\n"
    originalInfo="${originalInfo}""result:${free_memory}\n"
    if [ -z ${free_memory} ];then
        resultCode=1
        errorKey="${checkItemId}0001"   # 未查到内存
        originalInfo="${originalInfo}""result:Memory is not find."
        log ERROR "Memory is not find."
        log ERROR "FSM_${checkItemId}:unok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    if [ ${free_memory} -lt ${min_memory} ];then
        resultCode=1
        errorKey="${checkItemId}0002"   # 本地内存小于14G
        originalInfo="${originalInfo}""result:Memory is not enough.\n"
        log ERROR "Memory is not enough,."
        log ERROR "FSM_${checkItemId}:unok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    else
        originalInfo="${originalInfo}""result:Memory is enough.\n"
        log INFO "FSM_${checkItemId}:result:Memory is enough."
        log INFO "FSM_${checkItemId}:ok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}


