#!/bin/bash

#############################################################
#
# 名  称：检查/etc/logrotate.conf权限
# 错误码：
#         0000 正常
#         0001 权限未查到
#         0002 权限不正确（不为640权限）
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
#PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="1107"
resultCode=0
errorKey=""
params=""
originalInfo=""


function main()
{
    manager_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
       log INFO "${checkItemId} do not select, pass"
       return 0
    fi

    local cubeVersion=$(cat /opt/goku/services/csm/utils/version/VERSION.inner)
    originalInfo="${originalInfo}""command:cat /opt/goku/services/csm/utils/version/VERSION.inner\n"
    originalInfo="${originalInfo}""result:${cubeVersion}\n"
    if [ "${cubeVersion}" != "3.2.1.SPC200" ] && [ "${cubeVersion}" != "3.2.1.SPC100" ]; then
        resultCode=0
        errorKey="${checkItemId}0003"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    #查询/etc/logrotate.conf权限
    local check_permission=`ls -l /etc/logrotate.conf | awk '{print $1}'`
    originalInfo="${originalInfo}""command:ls -l /etc/logrotate.conf\n"
    originalInfo="${originalInfo}""result:${check_permission}\n"

    #定义/etc/logrotate.conf的标准权限
    standard_permission="-rw-r-----*"
    if [ -z ${check_permission} ];
    then
        resultCode=1
        errorKey="${checkItemId}0001"
        originalInfo="${originalInfo}""result:File permission is not find.\n"
        log ERROR "FSM_${checkItemId} result:File permission is not find."
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi
    if [[ ${check_permission} == ${standard_permission} ]];
    then
        originalInfo="${originalInfo}""result:File permissions are correct.\n"
        log INFO "FSM_${checkItemId}:ok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    else
        resultCode=1
        errorKey="${checkItemId}0002"
        originalInfo="${originalInfo}""result:Incorrect file permissions,file permission is not 640.\n"
        log ERROR "FSM_${checkItemId} result:Incorrect file permissions,file permission is not 640."
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
