#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="1108"
resultCode=0
errorKey=""
params=""
originalInfo=""


#FCC3.2版本，对应Storage 6.x
export QUERYSTATUS="/opt/omm/oms/workspace0/ha/module/hacom/script/status_ha.sh"
#FCC6.0版本，对应Storage 8.x
#export QUERYSTATUS="/opt/dfv/oam/oam-u/ha/ha/module/hacom/script/status_ha.sh"

SUCCESS=0
HA_ERROR=2



#############################################################
#
# 名  称：HA模式：主备double/单主single
# 
#############################################################
function isHA()
{
    local res=$(sudo "${QUERYSTATUS}")
    originalInfo="sudo "${QUERYSTATUS}""
    local haMode=$(echo "$res" | sed -n "2p" | awk '{print $1}')
    originalInfo="echo "$res""
    if [ "$haMode" = "double" ] 
    then
        log INFO "FSM_${checkItemId}: FSM_1108:ok.The HA mode is ${haMode}."
        return 1
    else
        log INFO "FSM_${checkItemId}: FSM_1108:ok.The HA mode is ${haMode}."
        return 0
    fi
}

#############################################################
#
# 名  称：检查是否为主active、备standby模式
#
#############################################################
function isHaErr()
{
    local res=""
    local res=$(sudo "${QUERYSTATUS}")

    local haVersion=$(echo "$res" | grep $(hostname) | awk '{print $3}')
    echo "$res" | grep ${haVersion} | awk '{print $6}' | grep "active"
    if [ $? = 0 ]
    then
        echo "$res" | grep ${haVersion} | awk '{print $6}' | grep "standby"
        if [ $? = 0 ]
        then
            log INFO "FSM_${checkItemId}: FSM_1108:ok. check HA status sucess."
            return 0
        fi
    fi
    log ERROR "HA status error."
    return 1
}

#############################################################
#
# 名  称：检查是否为主节点
#
#############################################################
function primaryStatusCheck()
{
    local res=$(sudo "${QUERYSTATUS}")
    LOG_INFO "$res"
    echo "$res" | grep $(hostname) | awk '{print $6}' | grep "active"
    return $?
}

#############################################################
#
# 名  称：检查是否为备节点
#
#############################################################
function standbyStatusCheck()
{
    local res=$(sudo "${QUERYSTATUS}")
    LOG_INFO "$res"
    echo "$res" | grep $(hostname) | awk '{print $6}' | grep "standby"
    return $?
}

#############################################################
#
# 名  称：判断是否为主
#
#############################################################
function isPrimary()
{
    local status=$(sudo "${QUERYSTATUS}" |grep $(hostname) | awk '{print $6}')
    if [ "$status" = "active" ]
    then
        log INFO "FSM_${checkItemId}:ok.The HA status is ${status}."
        return 1
    else
        log INFO "FSM_${checkItemId}:ok.The HA status is ${status}."
        return 0
    fi
}

#############################################################
#
# 名  称：检查FCC服务状态
#
#############################################################
function checkFccStatus()
{
    local isPirmary=$1
    haRes=$(sudo "${QUERYSTATUS}")
    errorInfo=$(echo "$haRes" | grep "Get Ha Status Failed")
    fccRes=$(echo "$haRes" | grep "fcc_.*")
    if [ -n "${errorInfo}" -o -z "${fccRes}" ]
    then
        errorKey="${checkItemId}0003"
        resultCode=1
        originalInfo="${originalInfo}""fcc is error, can't get any fcc resources infomation."
        log ERROR "FSM_${checkItemId}:unok.fcc is error, can't get any fcc resources infomation."
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi
    nodeName=$(echo "$haRes" | grep $(hostname) | awk '{print $1}')
    [ "$isPirmary" = 1 ] && res=$(echo "$haRes" | grep ${nodeName} | grep -E "fcc_.*|gaussDB" | awk '{print $3}' | grep -Ev "Normal|Active_normal")
    [ "$isPirmary" != 1 ] && res=$(echo "$haRes" | grep ${nodeName} | grep -E "fcc_.*|gaussDB" | awk '{print $3}' | grep -Ev "Stopping|Stopped|Standby_normal|Abnormal")

    if [ ! -z "${res}" ]
    then
        errorKey="${checkItemId}0004"
        resultCode=1
        log ERROR "checkFccStatus fail,FCC service status is : $res"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    else
        resultCode=0
        log INFO "checkFccStatus success,FCC service status is : $res"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        log INFO "checkFccStatus finished."
        return 0
    fi
}

#############################################################
#
# 名  称：检查FCC服务状态
# 错误码：
#         0001 HA status error
#         0002 节点不为主
#         0003 Get Ha Status Failed or fcc* does not exist
#         0004 checkFccStatus fail
#
#############################################################

function main()
{
    manager_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
       log INFO "${checkItemId} do not select, pass"
       return 0
    fi

    local cubeVersion=$(cat /opt/goku/services/csm/utils/version/VERSION.inner)
    originalInfo="${originalInfo}""command:cat /opt/goku/services/csm/utils/version/VERSION.inner\n"
    originalInfo="${originalInfo}""result:${cubeVersion}\n"
    if [ "${cubeVersion}" != "3.2.1.SPC100" ]; then
        resultCode=0
        errorKey="${checkItemId}0006"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    isHA
    if [ $? = 1 ];then
        log INFO "double fcc nodes."
        isHaErr
        if [ $? != 0 ]
        then
            resultCode=1
            errorKey="${checkItemId}0001"
            originalInfo="${originalInfo}""HA status error."
            log ERROR "HA status error."
            FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 1
        fi
        standbyStatusCheck
        [ $? = 0 ] && log INFO "This is secondary node."
        primaryStatusCheck
        [ $? = 0 ] && log INFO "This is primary node."
    else
        log INFO "single fcc nodes."
        isPrimary
        if [ $? != 1 ]
        then
            resultCode=1
            errorKey="${checkItemId}0002"
            originalInfo="${originalInfo}result:${status}\n"
            log ERROR "FSM_${checkItemId}:ok.The HA status is ${status}."
            FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 1
        fi
    fi

    roleNum=0
    isPrimary
    [ $? = 1 ] && roleNum=1

    checkFccStatus "$roleNum"
    return ${resultCode}
}


log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
