#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

#检查是否存在紧急、严重告警
source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="1109"
resultCode=0
errorKey=""
params=""
originalInfo=""

SU="$(which su)"

#PT DB ACCOUNT
FM_SYS_USER="fc2"
DB_PT_USER="dbadmin"
DB_PT_PORT=6432

DB_KEY=$(grep "^fc2:" /opt/goku/data/config/DBKey.cfg | sed "s/^fc2://")
DB_PT_PSW=$(/usr/local/bin/pwswitch -d "$DB_KEY")
export QUERYSTATUS="/opt/omm/oms/workspace0/ha/module/hacom/script/status_ha.sh"

#ERROR CODE

#############################################################
#
# 名  称：查询活动告警是否存在紧急、严重告警
# 错误码：
#         0000 不存在紧急、严重告警
#         0001 存在紧急、严重告警
#         0002 查询失败
#
#############################################################

function isPrimary()
{
    local status=$(sudo "${QUERYSTATUS}" | grep $(hostname) | awk '{print $6}')
    if [ "$status" = "active" ]
    then
        log INFO "FSM_${checkItemId}:ok.The HA status is ${status}."
        return 1
    else
        errorKey="${checkItemId}0004"
        log ERROR "FSM_${checkItemId}:ok.The HA status is ${status}."
        return 0
    fi
}

function check_main()
{
    manager_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
       log INFO "${checkItemId} do not select, pass"
       return 0
    fi

    isPrimary
    if [ $? -ne 1 ]
    then
        resultCode=0
        errorKey="${checkItemId}0004"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    local sqlCmd="SELECT COUNT(*) FROM FAULT.TBL_FM_ALARM_ACTIVE where SEVERITY ='1' or SEVERITY ='2';"
    local tableInfo="$(echo \"$DB_PT_PSW\" | xargs -i $SU - $DB_PT_USER -c "gsql -d allfmdb -U $FM_SYS_USER -W {} -p 6432 -t -c \" $sqlCmd \" 2>/dev/null ")"
    if [ -z "$tableInfo" ]
    then
        resultCode=1
        errorKey="${checkItemId}0003"
        originalInfo="${originalInfo}result:${tableInfo}\n"
        log ERROR "FSM_${checkItemId}:unok. Execute sql failed."
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    if [ $tableInfo != 0 ]
    then
        resultCode=1
        errorKey="${checkItemId}0002"
        originalInfo="${originalInfo}result:${tableInfo}\n"
        log ERROR "FSM_${checkItemId}:unok. The number of emergency and serious alarms is ${tableInfo}."
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    else
        resultCode=0
        errorKey="${checkItemId}0001"
        originalInfo="${originalInfo}result:${tableInfo}\n"
        log ERROR "FSM_${checkItemId}:ok. The number of emergency and serious alarms is zero."
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi
}


log MUST "enter [$0],para=[$@]"
check_main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
#retValue:1为存在，0为不存在
exit ${retValue}
