#! /bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
export QUERYSTATUS="/opt/omm/oms/workspace0/ha/module/hacom/script/status_ha.sh"

backupManualDir=/opt/gmbackup/db/manualbk/
backupAutoDir=/opt/gmbackup/db/
# 时间偏移(单位分钟)
timeOffset=1440
preciseTimeOffset=`expr ${timeOffset}*60*1000`
backupFileNamePrefix="gmdb-"
localFileArr=
localArrLen=0
checkItemId="1110"
resultCode=0
errorKey=""
params=""
originalInfo=""

# 是否检查自动备份
IS_CHECK_AUTO_BACKUP="N"

function hasBackupData()
{
    local backupTpe=$1
    local backupPath=${backupManualDir}
    if [[ ${backupTpe}x == "auto"x ]]
    then
        backupPath=${backupAutoDir}
    fi
    localFileArr=($(ls -l -t ${backupPath} | awk '{print $9}' | grep "${backupFileNamePrefix}"))
    originalInfo="${originalInfo}""command:ls -l -t /opt/gmbackup/db/manualbk/ | awk '{print \$9}' | grep 'gmdb-'\n"
    originalInfo="${originalInfo}""result:${localFileArr}\n"
    localArrLen=${#localFileArr[@]}
    if [[ ${localArrLen} -eq 0 ]]
    then
        log ERROR "The ${backupTpe} backup directory does not contain backup data that meets the requirements."
        return 1
    else
        log INFO "Manual backup files include: ${localFileArr[@]}"
        for localFile in ${localFileArr[@]}
        do
            log INFO "The current backup file is ${localFile}"
            localTime="${localFile:5:10} `echo ${localFile:16:8} | sed 's/-/:/g'`"
            log INFO "Backup time is ${localTime}"
            localTimeStamp=$((10#`date -d "$localTime" +%s`*1000+10#`date "+%N"`/1000000))
            diff=`expr ${currentTimeStamp} - ${localTimeStamp}`
            diff=${diff/-/}
            if [[ ${diff} -lt 0 ]] || [[ ${diff} -le ${preciseTimeOffset} ]]
            then
                log INFO "The latest backup file exists in the ${backupTpe} backup directory."
                return 0
            fi
        done
        log ERROR "The ${backupTpe} backup directory does not contain the latest backup file."
        return 1
    fi
}

function isPrimary()
{
    local status=$(sudo "${QUERYSTATUS}" |grep $(hostname) | awk '{print $6}')
    if [ "$status" = "active" ]
    then
        return 1
    else
        errorKey="${checkItemId}0002"
        return 0
    fi
}

function main()
{
    manager_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
       log INFO "${checkItemId} do not select, pass"
       return 0
    fi

    isPrimary
    if [ $? -ne 1 ]
    then
        resultCode=0
        errorKey="${checkItemId}0002"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    currentTime=`date "+%Y-%m-%d %H:%M:%S"`
    log INFO "The current system time is ${currentTime}"
    currentTimeStamp=$((10#`date -d "$currentTime" +%s`*1000+10#`date "+%N"`/1000000))

    hasBackupData "manual"
    checkMaualResult=$?
    if [[ ${checkMaualResult} -ne 0 ]]
    then
        if [[ ${IS_CHECK_AUTO_BACKUP}x == "Y"x ]]
        then
            hasBackupData "auto"
            checkAutoResult=$?
            if [[ ${checkAutoResult} -eq 0 ]]
            then
                resultCode=0
                originalInfo="${originalInfo}""result:The auto backup directory does not contain the latest backup file.\n"
                FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
                return 0
            fi
        fi
        resultCode=1
        errorKey="${checkItemId}0001"   # 手工备份目录最近24小时没有文件生成
        originalInfo="${originalInfo}""result:No file is generated in the manual backup directory in the latest 24 hours.\n"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    else
        resultCode=0
        originalInfo="${originalInfo}""result:The manual backup directory does not contain the latest backup file.\n"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}