#! /bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
export QUERYSTATUS="/opt/omm/oms/workspace0/ha/module/hacom/script/status_ha.sh"

checkItemId="1111"
resultCode=0
errorKey=""
params=""
originalInfo=""

SU="$(which su)"

#PT DB ACCOUNT
FM_SYS_USER="fc2"
DB_PT_USER="dbadmin"
DB_PT_PORT=6432

DB_KEY=$(grep "^fc2:" /opt/goku/data/config/DBKey.cfg | sed "s/^fc2://")
DB_PT_PSW=$(/usr/local/bin/pwswitch -d "$DB_KEY")
updaCfg="/opt/omm/oma/workspace/conf/upda.cfg"

function main()
{
    manager_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
       log INFO "${checkItemId} do not select, pass"
       return 0
    fi

    errorKey="${checkItemId}0008"
    getCubeVersion
    getScenario
    getStorageVersion
    getStorageEsn
    getDbnNum

    FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return ${resultCode}
}

function isPrimary()
{
    local status=$(sudo "${QUERYSTATUS}" |grep $(hostname) | awk '{print $6}')
    if [ "$status" = "active" ]
    then
        log INFO "FSM_${checkItemId}:ok.The HA status is ${status}."
        return 1
    else
        errorKey="${checkItemId}0008"
        log ERROR "FSM_${checkItemId}:ok.The HA status is ${status}."
        return 0
    fi
}

function getCubeVersion() {
    if [[ ! -f "/opt/goku/services/csm/utils/version/VERSION.inner" ]]
    then
        resultCode=1
        errorKey="${checkItemId}0001"   # VERSION.inner文件不存在
        originalInfo="${originalInfo}""result:/opt/goku/services/csm/utils/version/VERSION.inner is not exist.\n "
        params=""
        log ERROR "/opt/goku/services/csm/utils/version/VERSION.inner is not exist."
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    local cubeVersion=$(cat /opt/goku/services/csm/utils/version/VERSION.inner)
    originalInfo="${originalInfo}""command:cat /opt/goku/services/csm/utils/version/VERSION.inner\n"
    if [[ -n ${cubeVersion} ]]
    then
        params="${cubeVersion}"
        originalInfo="${originalInfo}""result:The current version is ${cubeVersion}.\n"
    else
        resultCode=1
        params=""
        errorKey="${checkItemId}0002"   # 获取版本信息失败
        originalInfo="${originalInfo}""result:Failed to obtain the version information.\n"
        log ERROR "Failed to obtain the version information."
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi
}

function getScenario() {
    if [[ ! -f "/opt/fc2/cfg/server_info.conf" ]]
    then
        resultCode=1
        errorKey="${checkItemId}0003"   # 获取服务器信息失败
        originalInfo="${originalInfo}""result:/opt/fc2/cfg/server_info.conf is not exist.\n"
        params="${params}"","""
        log ERROR "/opt/fc2/cfg/server_info.conf is not exist."
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    local scenario=$(cat /opt/fc2/cfg/server_info.conf | grep scenario | awk -F '=' '{print $2}' | sed 's/IaSS//g' | sed 's/aSS//g')
    originalInfo="${originalInfo}""command:cat /opt/fc2/cfg/server_info.conf | grep scenario\n"
    if [[ -n ${scenario} ]]
    then
        originalInfo="${originalInfo}""result:The current scenario is ${scenario}.\n"
        params="${params}"",${scenario}"
    else
        resultCode=1
        errorKey="${checkItemId}0004"   # 获取场景信息失败
        originalInfo="${originalInfo}""result:Failed to obtain the scenario information.\n"
        params="${params}"","""
        log ERROR "Failed to obtain the scenario information."
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi
}

function getStorageVersion() {
    if [[ ! -f "/opt/dsware/DSwareManagerNodeVersion" ]]
    then
        resultCode=1
        errorKey="${checkItemId}0005"
        params="${params}"","""
        originalInfo="${originalInfo}""/opt/dsware/DSwareManagerNodeVersion is not exist.\n"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    local storageVersion=$(cat /opt/dsware/DSwareManagerNodeVersion | grep "nodeVersion" | awk -F "=" '{print $2}')
    originalInfo="${originalInfo}""command: cat /opt/dsware/DSwareManagerNodeVersion \n"
    originalInfo="${originalInfo}""result:The current version is ${storageVersion} \n"
    params="${params}"",${storageVersion}"
}

function getStorageEsn() {
    if [[ ! -f "/opt/dsware/manager/webapps/dsware/WEB-INF/SystemConfiguration.xml" ]]
    then
        resultCode=1
        errorKey="${checkItemId}0006"
        params="${params}"","""
        originalInfo="${originalInfo}""/opt/dsware/manager/webapps/dsware/WEB-INF/SystemConfiguration.xml is not exist.\n "
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi
    local ESN=$(cat /opt/dsware/manager/webapps/dsware/WEB-INF/SystemConfiguration.xml | grep "system wwn"|awk -F '>' '{print $2}'|awk -F '<' '{print $1}')
    originalInfo="${originalInfo}""command: cat /opt/dsware/manager/webapps/dsware/WEB-INF/SystemConfiguration.xml\n"
    originalInfo="${originalInfo}""result:The Storage Esn is ${ESN}\n"
    params="${params}"",${ESN}"
}


function getDbnNum() {
    isPrimary
    if [ $? -eq 1 ]
    then
        local sqlCmd="select count(*) from irm.tbl_serverdevice  where INSTALLTYPE='DBN';"
        local dbnNum="$(echo \"$DB_PT_PSW\" | xargs -i  $SU - $DB_PT_USER -c "gsql -d allfmdb -U $FM_SYS_USER -W {} -p 6432 -t -c \" $sqlCmd \" 2>/dev/null ")"

        if [ ${dbnNum} -ge 0 ] 2>/dev/null ;then
           errorKey="${checkItemId}0009"
           params="${params}"",${dbnNum}"
           originalInfo="${originalInfo}""result:The number of DBN nodes is ${dbnNum}\n"
        else
          resultCode=1
          errorKey="${checkItemId}0007"
          log ERROR "FSM_${checkItemId}: Execute sql failed."
          return 1
        fi
    fi
}


log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
