#!/bin/bash
#检查存储池剩余空间

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

#输出到json文件中的checkItemId,每个检查脚本一个id
checkItemId="1114"
resultCode=0
errorKey=""
params=""
originalInfo=""

function check_pre_cert() {
  local cert_name=$1
  local cert_serial_number=$2
  cert_name=$(echo "${cert_name}" | tr -d '\n\r')
  if [[ "${cert_name}" =~ "nginx" ]]; then
    if [[ "${cert_serial_number}" =~ "D0719239D319D259" ]] || [[ "${cert_serial_number}" =~ "5DC98C6632397474" ]]; then
      resultCode=1
      params="${params}""${cert_name}\n"
    fi
  fi
}

function get_pre_cert() {
  declare -A cert_path
  cert_path[0]="/opt/goku/services/nginx/conf/SSL/server.crt:nginx server.crt"
  for cert in "${cert_path[@]}"; do
    path=$(echo "${cert}" | awk -F ':' '{print $1}')
    if [[ ! -f ${path} ]]; then
        continue
    fi
    local cert_until_time
    cert_until_time=$(openssl x509 -noout -in "$path" -enddate | awk -F '=' '{print$2}')
    local cert_serial
    cert_serial=$(openssl x509 -noout -in "$path" -serial | awk -F '=' '{print$2}')
    name=$(echo "${cert}" | awk -F ':' '{print $2}')
    local time_format
    time_format=$(date -d "${cert_until_time}" +'%Y-%m-%d %H:%M:%S')
    check_pre_cert "${name}" "${cert_serial}"
    originalInfo="${originalInfo}""${name} preset certificate:[Serial number:${cert_serial}] [Expire Time : ${time_format} (GMT)]\n"
  done
}

function main()
{
  manager_items_check ${checkItemId}
  if [ $? -ne 0 ]
  then
     log INFO "${checkItemId} do not select, pass"
     return 0
  fi
  if [ ! -d "/opt/goku/tomcat/bin" ]; then
    # 判断是FCC   CVM-FCC
    log INFO "FSM_${checkItemId}:ok"
    FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return 0
  fi
  get_pre_cert

  if [ "${resultCode}" == 1 ]; then
      resultCode=1
      errorKey="${checkItemId}0001"
      log ERROR "fcc_check_cert:unok"
      FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
      return 1
  else
      originalInfo="${originalInfo}""result:No preset certificate exists in the current environment."
      log INFO "${checkItemId}:fcc_check_cert:ok"
      FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
      return 0
  fi
}

log MUST "enter [$0],para=[$@]"
main "$@"
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
