#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }

FSM_OS=""
DswareVersion=""
If_existAbnormalProcess=""
If_existUnokPt=""
Vbs_NodeNum=""
Storage_NodeNum=""
Pool_Num=""
FSM_NTP_status=""
FSM_Manager_Status=""
RebalanceInfo_Status=""
FSM_HA_Mode=""
db_password=""

updaCfg="/opt/omm/oma/workspace/conf/upda.cfg"
ip=$(cat $updaCfg | grep "LOCALIP=" | awk -F '=' '{print $2}')

LOG_DIR="/var/log/dsware/FSM_${ip}_upgrade_precheck_collect.txt"
DSWARE_CLIENT_CONF_SERVER_PROPERTIES="/opt/dsware/manager/webapps/dsware/WEB-INF/manager.properties"
OLD_DSWARE_CLIENT_CONF_SERVER_PROPERTIES="/opt/dsware/client/conf/server.properties"
CURDIR="/opt/omm/oms/workspace/script"
CURPATH=`readlink -f $CURDIR`
CUR_WORK_PATH=$(dirname $CURPATH)
g_cfg_path="/opt/omm/oms/tools"
DbUsername=""
DecryptPasswd=""
VERSION_FILE="/opt/dsware/DSwareManagerNodeVersion"


function make_log()
{
    if [ -a $LOG_DIR ]
    then
        echo > $LOG_DIR
    else
        touch $LOG_DIR
    fi
    chmod 666 $LOG_DIR
    echo -e "-----------------------------------------------------------------------------------"| tee -a  $LOG_DIR
    echo "Begin to collect:"| tee -a $LOG_DIR
    echo -e "-----------------------------------------------------------------------------------"| tee -a $LOG_DIR
}


######获取admin权限
function get_admin_permission()
{
    if [ -f "${DSWARE_CLIENT_CONF_SERVER_PROPERTIES}" ]
    then
        user="$(cat "${DSWARE_CLIENT_CONF_SERVER_PROPERTIES}" | grep "hauser=" |awk -F 'hauser=' '{print $2}')"
    fi

    if [ -z "${user}" ]
    then
        user="$(cat "${OLD_DSWARE_CLIENT_CONF_SERVER_PROPERTIES}" | grep "hauser=" |awk -F 'hauser=' '{print $2}')"
    fi

    adminpwd=""

    if [ -f "${DSWARE_CLIENT_CONF_SERVER_PROPERTIES}" ]
    then
        adminpwd="$(cat "${DSWARE_CLIENT_CONF_SERVER_PROPERTIES}" | grep "hauser.pwd=" |awk -F 'hauser.pwd=' '{print $2}')"
    fi

    if [ -z "${adminpwd}" ]
    then
        adminpwd="$(cat "${OLD_DSWARE_CLIENT_CONF_SERVER_PROPERTIES}" | grep "hauser.pwd=" |awk -F 'hauser.pwd=' '{print $2}')"
    fi
}

######获取数据库密码
function get_db_password()
{
    getCipherPasswdTool="${g_cfg_path}/getdbNameOrPasswd"
    CipherPasswd=$(${getCipherPasswdTool} 2 | awk '{print $1}')
    version=$(grep -E "U2|R006" $VERSION_FILE)

    if [ -z "${version}" ]
    then
        db_password=$(decrpt_U1 ${CipherPasswd} | awk '{print $1}')
    else
        db_password=$(decrpt_U2 ${CipherPasswd} | awk '{print $1}')
    fi
}

######获取部署时间及当前时间
function get_time()
{
    check_DATE=`date`
    echo -e "check  Date:"$check_DATE"\n" |tee -a  $LOG_DIR

    time_tmp=`rpm -qa|grep dsware|grep manager`
    build_TIME=`rpm -qi $time_tmp|grep Install|awk -F 'Build' '{print $1}'`

    echo -e "$build_TIME""\n" |tee -a $LOG_DIR
    echo -e "---------------------------------------------------------------------------------" |tee -a  $LOG_DIR
}

######获取浮动IP
function get_float_ip()
{
    float_ip=`cat /opt/dsware/manager/webapps/dsware/WEB-INF/manager.properties |grep omm.address |awk -F '//' '{print $2}'`
    echo -e "float_ip=""$float_ip""\n\n" |tee -a  $LOG_DIR
    echo -e "---------------------------------------------------------------------------------"  |tee -a  $LOG_DIR
}

######获取安装版本，当前版本和ESN号
function get_Version_and_ESN()
{
    DswareVersion=`cat /opt/dsware/DSwareManagerNodeVersion |head -1|awk -F '=' '{print $2}'`;
    echo -e "Current_DswareVersion="$DswareVersion"\n\n" |tee -a  $LOG_DIR

    BuildDswareVersion=`rpm -qa |grep dsware|grep manager|awk -F '-' '{print $3}'`
    echo -e "BuildDswareVersion="$BuildDswareVersion"\n\n" |tee -a $LOG_DIR

    ESN=`cat /opt/dsware/manager/webapps/dsware/WEB-INF/SystemConfiguration.xml |grep "system wwn"|awk -F '>' '{print $2}'|awk -F '<' '{print $1}'`
    echo -e "FSM_ESN="$ESN"\n\n" |tee -a $LOG_DIR

    if [[ $DswareVersion =~ "V100R003" ]]
    then
        License="UNKOWN"
    else
        get_db_password

        sql_License="select LICENSESN from TBL_LIC_STATUS_CONTROL;"
        SQL_TMP="$(echo ${db_password} | xargs -i su - omm -c "gsql -U omm -p 21600 -W {} -c 'set search_path=dsware_1;${sql_License}'"|grep row|awk -F '(' '{print $2}'|awk '{print $1}')"

        if [ $SQL_TMP -eq 1 ]
        then
            License="NO"
        else
            License="YES"
        fi
    fi
    echo -e "License Status:""$License" |tee -a $LOG_DIR
    echo -e "---------------------------------------------------------------------------------"|tee -a  $LOG_DIR
}

######查询FSM服务状态
function get_FSM_status()
{
    fsm_Status=`su - dsware -c "export DswareTool_username=${user};export DswareTool_password=${adminpwd};sh /opt/dsware/client/bin/dswareTool.sh --op managerStatus"`
    FSM_Manager_Status=`echo "$fsm_Status"|grep "manager status"`
    echo -e "FSM_Manager_Status: "$FSM_Manager_Status"\n" |tee -a  $LOG_DIR

    if [[ $DswareVersion =~ "V100R003C02" ]]
    then
        FSM_HA_Mode=`sh /opt/omm/oms/workspace/ha/module/hacom/script/status_ha.sh |sed -n 2p`
        HA_status_tmp=`sh /opt/omm/oms/workspace/ha/module/hacom/script/status_ha.sh|head -6|grep DSM0|awk '{print $7}'`
    else
        FSM_HA_Mode=`sh /opt/dsware/manager/setup/forCommonServer/checkFSMStatus.sh |sed -n 2p`;
        HA_status_tmp=`sh /opt/dsware/manager/setup/forCommonServer/checkFSMStatus.sh|head -6|grep DSM0|awk '{print $7}'`
    fi

    echo -e "FSM_HA_Mode:"$FSM_HA_Mode"\n"|tee -a  $LOG_DIR
    count=0
    for i in `echo "$HA_status_tmp"`
    do
        if [ "$i" = "normal" ]
        then
            count=$[$count+1]
        fi
    done

    if [[ $FSM_HA_Mode =~ "single" ]]
    then
        case $count in
            0)
                echo "The single FSM node is abnormal" |tee -a $LOG_DIR
                ;;
            1)
                echo "The single FSM node is normal" |tee -a $LOG_DIR
                ;;
        esac
    else
        case $count in
            0)
                echo "Both FSM node ha status are abnormal" |tee -a $LOG_DIR
                ;;
            1)
                echo "only Primary node ha status is normal" |tee -a $LOG_DIR
                ;;
            2)
                echo "Both FSM node ha status is normal" |tee -a $LOG_DIR
                ;;
        esac
    fi

    echo -e "---------------------------------------------------------------------------------" |tee -a  $LOG_DIR
}

######获取FSM OS版本
function get_FSM_OS()
{
    FSM_OS=`cat /etc/*-release`;
    FSM_kernel=`uname -r`
    echo -e "FSM_kernel:""$FSM_kernel""\n" |tee -a $LOG_DIR
    echo -e "FSM_OS:""$FSM_OS""\n\n" |tee -a  $LOG_DIR

    if [ -d /opt/dsware/manager/setup/component/dr ]
    then
        echo -e "WARNING: This cluster exist dr service\n" |tee -a $LOG_DIR
    else
        echo -e "INFO: This cluster not exist dr service\n" |tee -a $LOG_DIR

    fi
    echo -e "---------------------------------------------------------------------------------"|tee -a  $LOG_DIR



}

######查询FSM NTP服务状态
function get_FSM_ntp_status()
{
    ntp_tmp=`ntpq -p |grep -E "\*|\+"|grep -v "LOCAL"|wc -l`;

    if [ "$ntp_tmp" -eq 0 ]
    then
        FSM_NTP_status="NTP service not exists or is abnormal";
    else
        FSM_NTP_status="NTP service is OK";
    fi

    echo -e "FSM_NTP_status:"$FSM_NTP_status"\n\n"|tee -a  $LOG_DIR
    echo -e "---------------------------------------------------------------------------------"|tee -a  $LOG_DIR
}

######查询PT状态
function get_unok_PT_exist()
{
    if [[ $DswareVersion =~ "V100R003C02" ]]
    then
        echo -e "All PT Status:NOT SUPPORT\n\n" |tee -a $LOG_DiR
    else
        unokPtNum=`su - dsware -c "export DswareTool_username=${user};export DswareTool_password=${adminpwd};sh /opt/dsware/client/bin/dswareTool.sh --op  checkExistUnokPt"`
        If_existUnokPt_tmp=`echo "$unokPtNum"|grep "The result"`

        if [ "$If_existUnokPt_tmp"x = "The result is:no"x ]
        then
            If_existUnokPt="OK"
        else
            If_existUnokPt="UNOK!!"
        fi
        echo -e "All PT Status:"$If_existUnokPt"\n\n" |tee -a  $LOG_DIR
    fi
}

######查询异常进程
function get_unok_Process_exist()
{
    unokProcessNum=`su - dsware -c "export DswareTool_username=${user};export DswareTool_password=${adminpwd};sh /opt/dsware/client/bin/dswareTool.sh --op queryNodeProcessInfo| grep NOK|wc -l"`;
    unokProcess=`su - dsware -c "export DswareTool_username=${user};export DswareTool_password=${adminpwd};sh /opt/dsware/client/bin/dswareTool.sh --op queryNodeProcessInfo"`;
    unokProcessInfo=`echo "$unokProcess"|awk '{if($1 ~ /^[0-9]./){X=$1};if($NF=="NOK"){print X"\n"$0}}'`

    if [ "$unokProcessNum" -eq 0 ];
    then
        If_existAbnormalProcess="OK"
        echo -e "All Process status(osd,vbs,mdc,zk):OK" |tee -a $LOG_DIR
    else
        If_existAbnormalProcess="UNOK, exist "$unokProcessNum" unok process:\n";
        echo -e "All Process status(osd,vbs,mdc,zk):"$If_existAbnormalProcess"\n"|tee -a  $LOG_DIR
        echo -e "$unokProcessInfo"|tee -a $LOG_DIR
    fi
    echo -e "---------------------------------------------------------------------------------"|tee -a  $LOG_DIR
}

######查询存储池信息
function get_storagePool_info()
{
    ALLStorage_NodeNum=0;

    get_db_password;

    StoragePoolInfo=`su - dsware -c "export DswareTool_username=${user};export DswareTool_password=${adminpwd};sh /opt/dsware/client/bin/dswareTool.sh --op queryStoragePool"`;
    echo "$StoragePoolInfo" |grep -E "^p|^[0-9]">/home/dsware/storagePoolInfo;

    PoolNum=`cat /home/dsware/storagePoolInfo |grep -P '^\d'|wc -l`;
    echo -e "StoragePool_Num="$PoolNum"\n\n"|tee -a  $LOG_DIR

    printf "%-15s %-20s %-15s %-20s %-15s %-15s %-15s %-20s %-15s %-15s %-15s %-15s %-15s %-15s\n" "pool_id" "pool_replication" "Ratio" "SecurityLevel" "TotalCapcity" "Cache_rate"  "UsedCapcity" "storage_node_num" "DataDisk_num" "DataDisk_size" "DataDisk_Type" "Cache_num" "Cache_size" "Cache_Type"|tee -a $LOG_DIR

    for ((i=0;i<$PoolNum;i++))
    do
        pool[i]=`cat /home/dsware/storagePoolInfo |sed -n $[2+$i]"p" `;
        pool_id=`echo ${pool[$i]} |awk '{print $1}'`;

        if [[ $DswareVersion =~ "V100R003C02" ]]
        then
            cache_rate="UNKOWN"
            security_level="UNKOWN"
        else
            query_pool_sql_cache_rate="select STORAGECACHERATE from TBL_STORAGE_POOL_INFO where POOLID='${pool_id}'"
            query_pool_sql_security_policy="select SECURITYLEVEL from TBL_STORAGE_POOL_INFO where POOLID='${pool_id}'"
            cache_rate_tmp=$(echo ${db_password} | xargs -i su - omm -c "gsql -U omm -p 21600 -W {} -c 'set search_path=dsware_1;${query_pool_sql_cache_rate}'"|sed -n 3p)
            security_level=$(echo ${db_password} | xargs -i su - omm -c "gsql -U omm -p 21600 -W {} -c 'set search_path=dsware_1;${query_pool_sql_security_policy}'"|sed -n 3p)
            security_level=`echo $security_level | sed -e 's/^[ \t]*//g'`
            cache_rate=`gawk -v j="$cache_rate_tmp" -v y=1 'BEGIN{printf "%.2f%%",j * 100/y}'`
        fi

        pool_name=`echo ${pool[$i]} |awk '{print $2}'`;

        if [[ $DswareVersion =~ "V100R006C10" || $DswareVersion =~ "V100R006C00SPC103" ]]
        then
            pool_TotalCapcity=`echo ${pool[$i]} |awk '{print $4}'`; pool_TotalCapcity=`awk 'BEGIN{printf "%.2f\n",'$pool_TotalCapcity'/1024/1024}'`
            pool_UsedCapcity=`echo ${pool[$i]} |awk '{print $5}'`; pool_UsedCapcity=`awk 'BEGIN{printf "%.2f\n",'$pool_UsedCapcity'/1024/1024}'`
            pool_allocatedCapcity=`echo ${pool[$i]} |awk '{print $6}'`; pool_allocatedCapcity=`awk 'BEGIN{printf "%.2f\n",'$pool_allocatedCapcity'/1024/1024}'`
            pool_replication=`echo ${pool[$i]} |awk '{print $9}'`;
        elif [[ $DswareVersion =~ "V100R006C20" || $DswareVersion =~ "V100R006C30" ]]
        then
            pool_TotalCapcity=`echo ${pool[$i]} |awk '{print $4}'`; pool_TotalCapcity=`awk 'BEGIN{printf "%.2f\n",'$pool_TotalCapcity'/1024/1024}'`
            pool_UsedCapcity=`echo ${pool[$i]} |awk '{print $5}'`; pool_UsedCapcity=`awk 'BEGIN{printf "%.2f\n",'$pool_UsedCapcity'/1024/1024}'`
            pool_allocatedCapcity=`echo ${pool[$i]} |awk '{print $6}'`; pool_allocatedCapcity=`awk 'BEGIN{printf "%.2f\n",'$pool_allocatedCapcity'/1024/1024}'`
            pool_redundancyPolicy=`echo ${pool[$i]} |awk '{print $9}'`;
            pool_replication=`echo ${pool[$i]} |awk '{print $10}'`;
            pool_ecRatio=`echo ${pool[$i]} |awk '{print $11}'`;
            pool_cellSize=`echo ${pool[$i]} |awk '{print $13}'`;
        else
            pool_TotalCapcity=`echo ${pool[$i]} |awk '{print $3}'`; pool_TotalCapcity=`awk 'BEGIN{printf "%.2f\n",'$pool_TotalCapcity'/1024/1024}'`
            pool_UsedCapcity=`echo ${pool[$i]} |awk '{print $4}'`; pool_UsedCapcity=`awk 'BEGIN{printf "%.2f\n",'$pool_UsedCapcity'/1024/1024}'`
            pool_allocatedCapcity=`echo ${pool[$i]} |awk '{print $5}'`; pool_allocatedCapcity=`awk 'BEGIN{printf "%.2f\n",'$pool_allocatedCapcity'/1024/1024}'`
            pool_replication=`echo ${pool[$i]} |awk '{print $8}'`;
        fi

        storage_node_num_tmp=`su - dsware -c "export DswareTool_username=${user};export DswareTool_password=${adminpwd};sh /opt/dsware/client/bin/dswareTool.sh --op queryStorageNodeInfo -id $pool_id"`
        storage_node_num=`echo "$storage_node_num_tmp"|grep nodeMgrIp |wc -l`;
        storage_Pool_Status_tmp=`su - dsware -c "export DswareTool_username=${user};export DswareTool_password=${adminpwd};sh /opt/dsware/client/bin/dswareTool.sh --op queryStoragePoolStatus -id $pool_id"`
        storage_Pool_Status=`echo "$storage_Pool_Status_tmp"|grep "StoragePool status"|awk -F ':' '{print $2}'`

        if [ $storage_Pool_Status -eq 0 ]
        then
            pool_Status="OK"
        else
            pool_Status="UNOK"
        fi

        DataDisk_num=`echo "$storage_node_num_tmp"|grep "diskUse" |wc -l`
        DataDisk_Type=`echo "$storage_node_num_tmp"|grep "diskUse"|head -1|awk -F ':' '{print $3}'|awk '{print $1}'`;
        DataDisk_size_arrays="`echo "$storage_node_num_tmp"|grep diskUse|awk '{print $3}'|awk -F ':' '{print $2}'`";
        datadisk_tmp=10000000
        datadisk_count=0

        for j in $DataDisk_size_arrays
        do
            if [ $datadisk_tmp -gt $j ]
            then
                datadisk_count=$[$datadisk_count+1]
                datadisk_tmp=$j
            fi
        done

        if [ $datadisk_count -eq 1 ]
        then
            DataDisk_size=$datadisk_tmp"G"
        else
            DataDisk_size=$datadisk_tmp"G(min)"
        fi

        if [[ $DswareVersion =~ "V100R003C02" ]]
        then
            Cache_Type=`cat /opt/dsware/manager/webapps/dsware/WEB-INF/DSwarePoolInfo.xml |grep hot_cache_media_type|awk -F '>' '{print $2}'|awk -F '<' '{print $1}'`
            Cache_size="`cat /opt/dsware/manager/webapps/dsware/WEB-INF/DSwarePoolInfo.xml |grep hot_cache_media_size|awk -F '>' '{print $2}'|awk -F '<' '{print $1}'`""G"
            Cache_num=`cat /opt/dsware/manager/webapps/dsware/WEB-INF/StorageCustomerConfiguration.xml |grep "osd cache" -c`
        else
            Cache_Type=`echo "$storage_node_num_tmp"|grep "cacheEsn"|head -1|awk -F ':' '{print $3}'|awk '{print $1}'`;
            Cache_size_arrays="`echo "$storage_node_num_tmp"|grep cacheSize|awk '{print $3}'|awk -F ':' '{print $2}'`";
            cache_tmp=10000000
            cache_count=0

            for j in $Cache_size_arrays
            do
                if [ $cache_tmp -gt $j ]
                then
                    cache_count=$[$cache_count+1]
                    cache_tmp=$j
                fi
            done

            if [ $cache_count -eq 1 ]
            then
                Cache_size=$cache_tmp"G"
            else
                Cache_size=$cache_tmp"G(min)"
            fi

            Cache_num=`echo "$storage_node_num_tmp"|grep "cacheEsn" |wc -l`
        fi

        case $DataDisk_Type in
            0)
                DataDisk_Type="unknown"
                ;;
            1)
                DataDisk_Type="SSD_card"
                ;;
            2)
                DataDisk_Type="SAS_SSD_disk"
                ;;
            3)
                DataDisk_Type="SATA_SSD_disk"
                ;;
            4)
                DataDisk_Type="SAS_dsik"
                ;;
            5)
                DataDisk_Type="SATA_disk"
                ;;
            6)
                DataDisk_Type="NVDIMM"
                ;;
            7)
                DataDisk_Type="NVME_ssd"
                ;;
        esac

        case $Cache_Type in
            0)
                Cache_Type="NVDIMM"
                ;;
            3)
                Cache_Type="SSD_card"
                ;;
            4)
                Cache_Type="SSD_disk"
                ;;
        esac

        ALLStorage_NodeNum=`expr $ALLStorage_NodeNum + $storage_node_num`;

        if [[ $DswareVersion =~ "V100R006" && $pool_redundancyPolicy =~ "ec" ]]
        then
            printf "%-15s %-20s %-15s %-20s %-15s %-15s %-15s %-20s %-15s %-15s %-15s %-15s %-15s %-15s\n" "$pool_id" "$pool_redundancyPolicy" "$pool_ecRatio" "$security_level" "$pool_TotalCapcity""T" "$cache_rate" "$pool_UsedCapcity""T" "$storage_node_num" "$DataDisk_num" "$DataDisk_size" "$DataDisk_Type" "$Cache_num" "$Cache_size" "$Cache_Type" |tee -a $LOG_DIR
        else
            printf "%-15s %-20s %-15s %-20s %-15s %-15s %-15s %-20s %-15s %-15s %-15s %-15s %-15s %-15s\n" "$pool_id" "Copy" "$pool_replication" "$security_level" "$pool_TotalCapcity""T" "$cache_rate" "$pool_UsedCapcity""T" "$storage_node_num" "$DataDisk_num" "$DataDisk_size" "$DataDisk_Type" "$Cache_num" "$Cache_size" "$Cache_Type" |tee -a $LOG_DIR
        fi
    done

    echo |tee -a $LOG_DIR
    echo -e "ALL_StorageNode_Num="$ALLStorage_NodeNum"\n\n"|tee -a  $LOG_DIR
    echo "---------------------------------------------------------------------------------"|tee -a  $LOG_DIR
}

######查询块个户端个数
function get_vbs_num()
{
    Vbs_NodeNum=`su - dsware -c "export DswareTool_username=${user};export DswareTool_password=${adminpwd};sh /opt/dsware/client/bin/dswareTool.sh --op queryDSwareClient| grep "ip:"|wc -l"`;
    echo -e "Vbs_NodeNum="$Vbs_NodeNum"\n\n"|tee -a  $LOG_DIR
    echo "---------------------------------------------------------------------------------"|tee -a  $LOG_DIR
}

######查询ZK节点信息
function get_zk_num()
{
    ZK_total_tmp=`su - dsware -c "export DswareTool_username=${user};export DswareTool_password=${adminpwd};sh /opt/dsware/client/bin/dswareTool.sh --op queryManageCluster"`
    total_num=`echo "$ZK_total_tmp"|wc -l`;
    total_tmp_num=`expr $total_num - 2`;
    total_tmp_num_p="$total_tmp_num""p"
    ZK_tmp=`echo "$ZK_total_tmp"| sed -n "5,${total_tmp_num_p}"`;
    ZK_Num=`echo "$ZK_tmp"|wc -l`;
    ZK_Type=`echo "$ZK_tmp"|head -1|awk '{print $4}'`;

    echo -e "ZK_NodeNum="$ZK_Num"\n"|tee -a  $LOG_DIR

    if [[ $DswareVersion =~ "V100R003C02" ]]
    then
        ZK_Size=`echo "$ZK_tmp"|head -1|awk '{print $6}'`;
        echo -e "ZK_Size="$ZK_Size"G\n" |tee -a $LOG_DIR
    else
        echo -e "ZK_Type:"$ZK_Type"\n"|tee -a  $LOG_DIR
    fi

    echo "---------------------------------------------------------------------------------"|tee -a  $LOG_DIR
}

######获取网络配置区间
function get_network_config()
{
    sys_tmp=`cat /opt/dsware/manager/webapps/dsware/WEB-INF/SystemConfiguration.xml`
    network_plane=`echo "$sys_tmp"|grep UVP|awk -F '>' '{print $2}'|awk -F '<' '{print $1}'`
    network_kind=`echo "$sys_tmp"|grep g_net_physical|awk -F '>' '{print $2}'|awk -F '<' '{print $1}'`
    echo -e  "network_plane= "$network_plane |tee -a $LOG_DIR
    echo -e  "network_kind= "$network_kind |tee -a $LOG_DIR
    echo |tee -a $LOG_DIR
    echo "-----------------------------------------------------------------------------------"|tee -a $LOG_DIR
}

decrpt_U1()
{
    [ -f "/etc/profile" ] && source /etc/profile
    [ -f "/home/omm/.bashrc" ] && source "/home/omm/.bashrc"

    local parmas="$1"
    local rootDir="${CUR_WORK_PATH}"
    local selfDir="${CUR_WORK_PATH}/tools/encrypt"
    local wcc=$(find ${rootDir}/lib/ -maxdepth 1 -name wc2frm*.jar)
    local classpath="${wcc}:${selfDir}/main.jar"
    local className="com.omm.encrypt.DecryptCommandMain"
    local java_cmd="/opt/omm/oms/jre/bin/java -cp ${classpath} ${className}"
    local result=$(${java_cmd} strSrc:"$parmas" encType:AES256_CBC 2>/dev/null)

    echo "$result"
}

decrpt_U2()
{
    [ -f "/etc/profile.d/omm-oms.sh" ] && source /etc/profile.d/omm-oms.sh >/dev/null 2>&1

    local parmas="$1"
    local rootDir="${CUR_WORK_PATH}"
    local selfDir="${CUR_WORK_PATH}/tools/encrypt"
    local wcc=$(find ${rootDir}/lib/ -maxdepth 1 -name wc2frm*.jar)
    local log4j=$(find ${rootDir}/lib/ -maxdepth 1 -name 'log4j*.jar')
    local commons=$(find ${rootDir}/lib/ -maxdepth 1 -name 'commons-codec*.jar')
    local javaArgs="-Dbeetle.application.home.path=${rootDir}/security/config"
    local classpath="${wcc}:${log4j}:${commons}:${selfDir}/main.jar"
    local className="com.omm.encrypt.DecryptCommandWithoutParam"
    local java_cmd="/opt/omm/oms/jre/bin/java -cp ${classpath} ${javaArgs} ${className}"
    local result=`${java_cmd} 2>/dev/null <<EOF
strSrc:$parmas
encType:AES256_CBC
EOF`
    echo "$result"
}


function main()
{
    make_log;
    get_admin_permission;
    get_time;
    get_Version_and_ESN;
    get_float_ip;
    get_FSM_status;
    get_FSM_OS;
    get_FSM_ntp_status;
    get_unok_PT_exist;
    get_unok_Process_exist;
    get_vbs_num;
    get_zk_num;
    get_network_config;
    get_storagePool_info;

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}