#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib/"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/dswareTool_lib.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/dswareTool_lib.sh failed."; exit 130; }


checkItemId=3

main()
{
    RunResult=`run_dswaretool managerStatus`
    echo "${RunResult}" |grep -iE "MON|TUE|WED|THU|FRI|SAT|SUN" >/dev/null 2>&1

    if [ $? -ne 0 ]
    then
        resultCode=1
        errorKey="${checkItemId}0001"  # 0001 FSM 服务器语言为中文
        params=""
        originalInfo="command:""run_dswaretool managerStatus\n""result:$RunResult\n FSM OS language check:unok"
        log ERROR "${checkItemId}FSM_check_OS_language: FSM OS is not English language"
        log ERROR "${checkItemId}FSM_check_OS_language:unok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    else
        resultCode=0
        errorKey=''
        params=''
        originalInfo="command:""run_dswaretool managerStatus\n""result:$RunResult\n FSM OS language check:ok"
        log INFO "${checkItemId}FSM_check_OS_language:ok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#                            #
#  错误码(errorKey)：         #
#  0001：平台语言环境为中文。  #
#                            #
##############################