#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

#输出到json文件中的checkItemId,每个检查脚本一个id
checkItemId="58"
resultCode=0
errorKey=""
params=""
originalInfo=""

function check_main()
{
    buildDate=$(cat /opt/dsware/DSwareManagerNodeVersion | grep "buildDate=")
    originalInfo="command:cat /opt/dsware/DSwareManagerNodeVersion | grep buildDate= \n""review:${buildDate} \n"

    #6.2SPC300私有云发布的时间：buildDate=2019-01-21
    if [[ "${buildDate}" == "buildDate=2019-01-21" ]]
    then
        log INFO "The version released by the private cloud. ${buildDate}"
        originalInfo="${originalInfo}""The version released by the private cloud, check result: OK"
        return 0
    fi
    #不是私有云发布的版本
    log ERROR "Not a version released by private cloud. ${buildDate}"
    originalInfo="${originalInfo}""ERROR: Not a version released by the private cloud."
    resultCode=1
    errorKey="${checkItemId}""0001"
    return 1
}

function main()
{
    src_version=$(cat /opt/dsware/DSwareManagerNodeVersion | grep "nodeVersion=" | awk -F "=" '{print $2}')

    if [[ "${src_version}" == "V100R006C20SPC300" ]]
    then
        log INFO "Current version is ${src_version}, begin to check ..."
        check_main
    else
        originalInfo="Current version is ${src_version}, no need to check."
        log INFO "${originalInfo}"
    fi

    FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return "${resultCode}"
}

# --------------------------------------------------------------------------- #
#                          脚本开始运行
# --------------------------------------------------------------------------- #
log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
