#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

checkItemId="7"
resultCode=0
errorKey=""
params=""
originalInfo=""

main()
{

    audit_log="/var/log/dsware/manager/log-fsm-audit.log"
    permission=$(ls -l ${audit_log} |awk '{print $3":"$4}')
    originalInfo="command:ls -l ${audit_log} |awk '{print \$3 \$4}'\n"
    originalInfo="${originalInfo}""review:${permission}\n"
    if [[ -f "${audit_log}" && "${permission}" != "omm:omm" ]]
    then
        resultCode=1
        errorKey="${checkItemId}0001"    #  0001 log-fsm-audit.log 不属于 omm：omm 所有
        originalInfo="${originalInfo}""result:FSM log-fsm-audit.log owner is not omm:omm, but ${permission}"
        log ERROR "${checkItemId}FSM_check_audit_log.sh:FSM log-fsm-audit.log owner is not omm:omm, but ${permission}"
        log ERROR "${checkItemId}:FSM_check_audit_log.sh:unok."
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    else
        originalInfo="${originalInfo}""result:FSM log-fsm-audit.log owner is omm:omm."
        log INFO "${checkItemId}:FSM_check_audit_log.sh:ok."
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001 log-fsm-audit.log 不属于 omm：omm 所有
#
##############################