#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

#输出到json文件中的checkItemId,每个检查脚本一个id
checkItemId="4"
resultCode=0
errorKey=""
params=""
originalInfo=""

main()
{
    if [[ -f /opt/dsware/DSwareAgentNodeVersion && -f /opt/dsware/DSwareManagerNodeVersion ]]
    then
        originalInfo="${originalInfo}""result:this FSM point deploy with FSA."
        log INFO "${checkItemId}FSM_check_deploy_FSA.sh:this FSM point deploy with FSA."

        local managerVersion=`cat /opt/dsware/DSwareManagerNodeVersion | grep -i version | awk -F '=' '{print$2}'`
        originalInfo="${originalInfo}""command:cat /opt/dsware/DSwareManagerNodeVersion | grep -i version | awk -F '=' '{print\$2}'\n"
        originalInfo="${originalInfo}""review:managerVersion is ${managerVersion}\n"
        local agentVersion=`cat /opt/dsware/DSwareAgentNodeVersion | grep -i version | awk -F '=' '{print$2}'`
        originalInfo="${originalInfo}""command:cat /opt/dsware/DSwareAgentNodeVersion | grep -i version | awk -F '=' '{print\$2}'\n"
        originalInfo="${originalInfo}""review:agentVersion is ${agentVersion}\n"

        if [[ "${managerVersion}"x !=  "${agentVersion}"x ]]
        then
            resultCode=1
            errorKey="${checkItemId}0001"    #  0001 FSM 和 FSA 为合部，且版本不一致；
            originalInfo="${originalInfo}""result:FSA_version not equal FSM_version."
            log ERROR "${checkItemId}FSM_check_deploy_FSA.sh:FSA_version not equal FSM_version."
            log ERROR "${checkItemId}:FSM_check_deploy_FSA.sh:unok"
            FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 1
        else
            update_dir_user_owner=`ls -l /opt/dsware | grep -i update | awk '{print$3}'`
            originalInfo="${originalInfo}""command:ls -l /opt/dsware | grep -i update | awk '{print\$3}'\n"
            originalInfo="${originalInfo}""review:/opt/dsware/update dir user_owner is ${update_dir_user_owner}\n"
            update_dir_group_owner=`ls -l /opt/dsware | grep -i update | awk '{print$4}'`
            originalInfo="${originalInfo}""command:ls -l /opt/dsware | grep -i update | awk '{print\$4}'\n"
            originalInfo="${originalInfo}""review:/opt/dsware/update dir user_owner is ${update_dir_group_owner}\n"
            if [[ "${update_dir_user_owner}" != "dsware" || "${update_dir_group_owner}" != "omm" ]]
            then 
                resultCode=1
                errorKey="${checkItemId}0002"    #  0002 /opt/dsware/update 目录所有者有误（目录所有人不是dsware，或目录所有团队不是omm，或以上两种情况皆有）
                originalInfo="${originalInfo}""review:dir_user_owner is not dsware or dir_group_owner is not omm."
                log ERROR "${checkItemId}FSM_check_deploy_FSA.sh:dir_user_owner is not dsware or dir_group_owner is not omm."
                log ERROR "${checkItemId}:FSM_check_deploy_FSA.sh:unok"
                FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
                return 1
            else
                originalInfo="${originalInfo}""result:the privilege of /opt/dsware/update is right."
                log INFO "${checkItemId}FSM_check_deploy_FSA.sh:the privilege of /opt/dsware/update is right."
            fi
        fi
    else
        originalInfo="${originalInfo}""result:FSM do not deploy with FSA."
        log INFO "${checkItemId}FSM_check_deploy_FSA.sh:FSM do not deploy with FSA."
    fi

    log INFO "${checkItemId}:FSM_check_deploy_FSA.sh:ok"
    FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return 0

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
