#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" || { echo "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="9"
resultCode=0
errorKey=""
params=""
originalInfo=""

main()
{
    target_version="$(get_package_version)"
    #FSM 各目录需要空间大小 单位：M  需求 /opt 3G (FSM和FSA合布则需要5G) ; /var/log 300M; /tmp 10M ; /home 50M
    if [[ ${target_version} =~ V100R006C30SPC80[0-3] ]];then
        [ -f /opt/dsware/DSwareAgentNodeVersion ] && optNeedSpace="5620" || optNeedSpace="3572"
    elif [[ ${target_version} =~ V100R006C30SPC80[5-9] ]] || [[ ${target_version} =~ V100R006C30SPC8[1-9] ]];then
        [ -f /opt/dsware/DSwareAgentNodeVersion ] && optNeedSpace="6000" || optNeedSpace="5000"
    else
        [ -f /opt/dsware/DSwareAgentNodeVersion ] && optNeedSpace="5120" || optNeedSpace="3072"
    fi
    
    varLogNeedSpace="300"
    tmpNeedSpace="10"
    homeNeedSpace="50"

    opt_Available="$(df -mP "/opt" |tail -n1 | awk '{print $4}')"
    originalInfo="${originalInfo}""command:df -mP /opt |tail -n1 | awk '{print \$4}\n"
    originalInfo="${originalInfo}""review:${opt_Available}M\n"
    if [ ${opt_Available} -lt ${optNeedSpace} ]
    then
        resultCode=1
        error_opt_num=1
        originalInfo="${originalInfo}""result:/opt available space less than ${optNeedSpace}M\n"
        log ERROR "${checkItemId}FSM_check_disk_space.sh:/opt available space less than ${optNeedSpace}M"
    else
        error_opt_num=0
    fi

    
    var_Available="$(df -mP "/var/log" |tail -n1 | awk '{print $4}')"
    originalInfo="${originalInfo}""command:df -mP /var/log |tail -n1 | awk '{print \$4}'\n"
    originalInfo="${originalInfo}""review:${var_Available}M\n"
    if [ ${var_Available} -lt ${varLogNeedSpace} ]
    then
        resultCode=1
        error_var_num=2
        originalInfo="${originalInfo}""/var/log available space less than ${varLogNeedSpace}M\n"
        log ERROR "${checkItemId}FSM_check_disk_space.sh:/var/log available space less than ${varLogNeedSpace}M"
    else
        error_var_num=0
    fi

    
    tmp_Available="$(df -mP "/tmp" |tail -n1 | awk '{print $4}')"
    originalInfo="${originalInfo}""command:df -mP /tmp |tail -n1 | awk '{print \$4}'\n"
    originalInfo="${originalInfo}""review:${tmp_Available}M\n"
    if [ ${tmp_Available} -lt ${tmpNeedSpace} ]
    then
        resultCode=1
        error_tmp_num=4
        originalInfo="${originalInfo}""/tmp free available less than ${tmpNeedSpace}M\n"
        log ERROR "${checkItemId}FSM_check_disk_space.sh:/tmp free available less than ${tmpNeedSpace}M"
    else
        error_tmp_num=0
    fi
    

    home_Available="$(df -mP "/home" |tail -n1 | awk '{print $4}')"
    originalInfo="${originalInfo}""command:df -mP /home |tail -n1 | awk '{print \$4}'\n"
    originalInfo="${originalInfo}""review:${home_Available}M\n"
    if [ ${home_Available} -lt ${homeNeedSpace} ]
    then
        resultCode=1
        error_home_num=8
        originalInfo="${originalInfo}""/home available space less than ${homeNeedSpace}M\n"
        log ERROR "${checkItemId}FSM_check_disk_space.sh:/home available space less than ${homeNeedSpace}M"
    else
        error_home_num=0
    fi


    if [ ${resultCode} -ne 0 ]
    then
        errorKey="${checkItemId}0000"
        error_total=$[${error_home_num}+${error_opt_num}+${error_tmp_num}+${error_var_num}]
        errorKey=$[${errorKey}+${error_total}]
        log ERROR "${checkItemId}:FSM_check_disk_space.sh:unok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    else
        log INFO "${checkItemId}:FSM_check_disk_space.sh:ok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001 /opt                              目录空间不足
#  0002 /var/log                          目录空间不足
#  0003 /opt , /var/log                   目录空间不足
#  0004 /tmp                              目录空间不足
#  0005 /tmp , /opt                       目录空间不足
#  0006 /tmp , /var/log                   目录空间不足
#  0007 /tmp , /var/log , /opt            目录空间不足
#  0008 /home                             目录空间不足
#  0009 /home , /opt                      目录空间不足
#  0010 /home , /var/log                  目录空间不足
#  0011 /home , /var/log , /opt           目录空间不足
#  0012 /home , /tmp                      目录空间不足
#  0013 /home , /tmp , /opt               目录空间不足 
#  0014 /home , /tmp , /var/log           目录空间不足
#  0015 /home , /tmp , /var/log , /opt    目录空间不足
#
##############################