#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

checkItemId="5"
resultCode=0
errorKey=""
params=""
originalInfo=""

main()
{

    tmp2=`cat /opt/dsware/manager/webapps/dsware/WEB-INF/manager-ha.properties | grep double_plane |grep -i true -c`
    originalInfo="command:cat /opt/dsware/manager/webapps/dsware/WEB-INF/manager-ha.properties | grep double_plane |grep -i true -c\n"
    originalInfo="${originalInfo}""review:${tmp2}\n"
    if [ $tmp2 -gt 0 ]
    then
        resultCode=1
        errorKey="${checkItemId}0001"    #  0001 FSM 开启了双平面管理
        originalInfo="${originalInfo}""result:FSM better not use double plane."
        log ERROR "${checkItemId}FSM_check_double_plane.sh:FSM use double plane."
        log ERROR "${checkItemId}:FSM_check_double_plane.sh:unok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    else
        originalInfo="${originalInfo}""result:FSM not use double plane."
        log INFO "${checkItemId}:FSM_check_double_plane:ok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001 FSM 开启了双平面管理
#
##############################