#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

#输出到json文件中的checkItemId,每个检查脚本一个id
checkItemId="55"
resultCode=0
errorKey=""
params=""
originalInfo=""

function check_main()
{
    osKernel=$(uname -r)
    originalInfo="command:uname -r \n""review:${osKernel}"
    log INFO "uname -r: ${osKernel}"

    if [[ -z "${osKernel}" ]]
    then
        log ERROR "Run: uname -r. The returned result is empty."
        resultCode=1
        errorKey="${checkItemId}""0002"
        return 1
    fi

    if [[ "${osKernel}" == "3.10.0-327.59.59.37.h22.x86_64" ]]
    then
        log ERROR "uname -r: ${osKernel}, need to contact technical engineer."
        resultCode=1
        errorKey="${checkItemId}""0001"
        return 1
    fi

    log INFO "check euler os version OK"
    return 0
}

function main()
{
    if [[ -f /etc/euleros-release ]]
    then
        log INFO "begin to check euler os version."
        check_main
    else
        originalInfo="Not euler os. No need to check."
        log INFO "${originalInfo}"
    fi

    FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return "${resultCode}"
}

# --------------------------------------------------------------------------- #
#                          脚本开始运行
# --------------------------------------------------------------------------- #
log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
