#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

#输出到json文件中的checkItemId,每个检查脚本一个id
checkItemId="2"
resultCode=0
errorKey=""
params=""
originalInfo=""

#获取源版本
src_version="$(get_src_version)"

# --------------------------------------------------------------------------- #
#                          全局变量
# --------------------------------------------------------------------------- #
manageLocalIpFile="/opt/omm/oms/workspace/ha/module/harm/plugin/conf/DSMmanagerLocalIp.xml"
serviceLocalIpFile="/opt/omm/oms/workspace/ha/module/harm/plugin/conf/DSMserviceLocalIp.xml"
managerHaProp="/opt/omm/oms/workspace/webapps/dsware/WEB-INF/manager-ha.properties"
hacom_xml="/opt/omm/oms/workspace/ha/module/hacom/conf/hacom.xml"
NET_WORK_TYPE_FILE="/opt/omm/oma/workspace/conf/upda.cfg"
IP_TYPE=""
hamode=""

##############################################################
## @Usage getNetworkType
## @Return 0 : succ
## @Description get networkType ipv4/ipv6
##############################################################
function get_net_work_type()
{
    IP_TYPE=$(cat ${NET_WORK_TYPE_FILE} | grep -w -E "^P_MANAGER_IP_FAMILY" | awk -F '=' '{print $2}')
    if [ "Xipv4" != "X${IP_TYPE}" -a "Xipv6" != "X${IP_TYPE}" ];then
        [[ -z "${IP_TYPE}" ]] && IP_TYPE="ipv4" || { log ERROR "P_MANAGER_IP_FAMILY:${IP_TYPE} error!"; return 1; }
    fi

    log "NOTICE" "P_MANAGER_IP_FAMILY=${IP_TYPE}"
    return 0
}

function ping_gateway()
{
    #获取网关
    local manager_gateway=`cat $manageLocalIpFile|grep manager_gateway|awk 'BEGIN{RS=" +|/|<|>";FS="="}{if($1=="value"){gsub("\"","",$2);print $2}}'`
    local service_gateway=`cat $serviceLocalIpFile|grep service_gateway|awk 'BEGIN{RS=" +|/|<|>";FS="="}{if($1=="value"){gsub("\"","",$2);print $2}}'`
    #获取单双平面
    local isDoublePlane=$(cat $managerHaProp | grep -w "double_plane" | sed "s/[[:space:]]//g" | awk -F "=" '{print $2}')

    if [ "Xipv4" == "X${IP_TYPE}" ];then
        #如果是双平面并且网关不是255.255.255.255时才检查
        if [[ "true" == "${isDoublePlane}" && "$manager_gateway" != "255.255.255.255" ]]
        then
            result=$(ping -c 1 -W 1 $manager_gateway)
            ret=$?
            originalInfo="command: ping -c 1 -W 1 $manager_gateway""\n""${result}\n"
            if [ "${ret}" -ne 0 ]
            then
                log ERROR "manager_gateway $manager_gateway is unreachable."
                originalInfo="${originalInfo}""ERROR: manager_gateway $manager_gateway is unreachable.\n"
                resultCode=1
                errorKey="20001"
            fi
        fi
        #如果网关是255.255.255.255时不作检查
        if [ "$service_gateway" != "255.255.255.255" ]
        then
            result=$(ping -c 1 -W 1 $service_gateway)
            ret=$?
            originalInfo="${originalInfo}""command: ping -c 1 -W 1 $service_gateway\n""${result}\n"
            if [ "${ret}" -ne 0 ]
            then
                log ERROR "service_gateway $service_gateway is unreachable."
                originalInfo="${originalInfo}""ERROR: service_gateway $service_gateway is unreachable.\n"
                resultCode=1
                errorKey="20001"
                return 1
            fi
        fi
    else
        result=$(ping6 -c 1 -W 1 $manager_gateway)
        ret=$?
        originalInfo="ping6 -c 1 -W 1 $manager_gateway""\n""${result}\n"
        if [ "${ret}" -ne 0 ]
        then
            log ERROR "manager_gateway $manager_gateway is unreachable."
            originalInfo="${originalInfo}""ERROR: manager_gateway $manager_gateway is unreachable.\n"
            resultCode=1
            errorKey="20001"
        fi

        result=$(ping6 -c 1 -W 1 $service_gateway)
        ret=$?
        originalInfo="${originalInfo}""ping6 -c 1 -W 1 $service_gateway""${result}\n"
        if [ "${ret}" -ne 0 ]
        then
            log ERROR "service_gateway $service_gateway is unreachable."
            originalInfo="${originalInfo}""ERROR: service_gateway $service_gateway is unreachable.\n"
            resultCode=1
            errorKey="20001"
            return 1
        fi
    fi

    return 0
}

function check_main()
{
    # 读取当前OMS的安装模式
    hamode=$(grep -w 'hamode value' "${hacom_xml}" | awk -F'"' '{print $2}')
    if [ "${hamode}" != "double" ];then
        originalInfo="HA mode is ${hamode}, no need check gateway."
        log INFO "${originalInfo}"
        return 0
    fi

    get_net_work_type

    ping_gateway

    return 0
}

function main()
{
    if [[ ${src_version} == V100R006* ||  ${src_version} == V100R003C30U2* ]]
    then
        log INFO "Current version is ${src_version}, begin to check gateway."
        check_main
    else
        originalInfo="Current version is ${src_version}, no need to check gateway."
        log INFO "${originalInfo}"
    fi

    FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return "${resultCode}"
}

# --------------------------------------------------------------------------- #
#                          脚本开始运行
# --------------------------------------------------------------------------- #
log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
