#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
source "${UPG_LIB_PATH}/func.sh"|| { log ERROR "source ${UPG_LIB_PATH}/func.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/dswareTool_lib.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/dswareTool_lib.sh failed."; exit 130; }

checkItemId="67"
resultCode=0
errorKey=""
params=""
originalInfo=""

# 获取最大iops值, 参数1：存储池ID；参数2：读 或 写
function get_max_iops_value()
{
    local node_flag="${1}"
    local iops_type="${2}"
    local table_value=3
    log INFO "node_flag=${node_flag}; iops_type=${iops_type}"
    query_iops_sql="select * from pg_tables where TABLENAME like '%${iops_type}%' order by TABLENAME;"
    table_name_list=($(echo ${db_password} | xargs -i su - omm -c "gsql -U omm -p 21600 -W {} -c \"set search_path=omm_1;$query_iops_sql\"" | grep "OMM_1"| tail -${table_value} | awk -F"|" '{print $2}'))
    log INFO "set search_path=omm_1;$query_iops_sql"
    log INFO "table_name_list=${table_name_list[@]}"

    [[ "${#table_name_list[@]}" -eq 0 ]] && return 1

    max_iops_value=0
    for table_name in ${table_name_list[@]}
    do
        query_iops_value1="SELECT * FROM ${table_name} WHERE NODE=${node_flag} ORDER BY CAST(ITEMVALUE AS DECIMAL) DESC LIMIT 1;"
        iops_value=$(echo ${db_password} | xargs -i su - omm -c "gsql -U omm -p 21600 -W {} -c 'set search_path=omm_1;${query_iops_value1}'" | tail -3 | head -1 | awk -F"|" '{print$3}'|sed 's/ //g')
        log INFO "review:${iops_value}"
        # 无对应存储ID的iops 则设置为0
        [[ -z "${iops_value}" ]] && iops_value=0
        if [[ $(echo "${iops_value} ${max_iops_value}" | awk '{if($1>=$2) {print 1} else {print 0}}') -eq 1 ]]
        then
            max_iops_value=${iops_value}
            table_name_info=${table_name}
        fi
    done

    [[ "${iops_type}" == "PMD_POOL_W_S_" ]] && { max_write_iops_value=${max_iops_value}; max_type_name="max_write_iops_value"; } || { max_read_iops_value=${max_iops_value}; max_type_name="max_read_iops_value"; }

    log INFO "table_name:${table_name_info}; result:${max_type_name}=${max_iops_value}"
    originalInfo="${originalInfo}""table_name:${table_name_info}""\n""result:${max_type_name}=${max_iops_value}\n"

    return 0
}

function check_main()
{
    storage_pool_info=$(run_dswaretool queryStoragePool | grep -E '^[0-9]+')
    pool_id_list=($(echo "${storage_pool_info}" | egrep -o '^[0-9]+'))

    originalInfo="${originalInfo}""command:/opt/dsware/client/bin/dswareTool.sh --op queryStoragePool\n"
    originalInfo="${originalInfo}""result:pool_id_list=${pool_id_list[@]}\n"
    log INFO "pool_id_list=${pool_id_list[@]}"

    error_info=""
    for pool_id in ${pool_id_list[@]}
    do
        max_write_iops_value=0
        max_read_iops_value=0

        # 原始信息中化分pool_id值
        originalInfo="${originalInfo}""\n""pool_id=${pool_id}\n"

        # 获取对应pool_id的副本数
        if [[ $(get_src_version) == V100R006C00SPC103 || $(get_src_version) =~ V100R006C10 ]]
        then
            pool_type="replication"
            replicationFactor=$(echo "${storage_pool_info}" | grep -wE "^${pool_id}" | awk '{print $9}')
            originalInfo="${originalInfo}""pool_type=${pool_type}""\n""replicationFactor=${replicationFactor}""\n"
        elif [[ $(get_src_version) =~ V100R006C[23]0 ]]
        then
            echo "${storage_pool_info}" | grep -wE "^${pool_id}" | grep -w "replication" >> /dev/null && pool_type="replication" || pool_type="ec"
            if [[ "${pool_type}" == "ec" ]]
            then
                ecRatio=$(echo "${storage_pool_info}" | grep -wE "^${pool_id}" | awk '{print $11}' |sed 's/ //g')
                log INFO "ecRatio=${ecRatio};"
                replicationFactor=$(echo "${ecRatio}" | awk -F":" '{print $1}'| awk -F"+" '{print ($1+$2)/$1}')
                originalInfo="${originalInfo}""pool_type=${pool_type}""\n""ecRatio=${ecRatio}""\n""replicationFactor=${replicationFactor}""\n"
            else
                replicationFactor=$(echo "${storage_pool_info}" | grep -wE "^${pool_id}" | awk '{print $10}')
                originalInfo="${originalInfo}""pool_type=${pool_type}""\n""replicationFactor=${replicationFactor}""\n"
            fi
        else
            pool_type="replication"
            replicationFactor=$(echo "${storage_pool_info}" | grep -wE "^${pool_id}" | awk '{print $8}')
            originalInfo="${originalInfo}""pool_type=${pool_type}""\n""replicationFactor=${replicationFactor}""\n"
        fi

        # 获取对应pool_id的正常运行的OSD个数
        osd_disk_num=$(run_dswaretool_new  --op queryStorageNodeInfo -id ${pool_id} | grep -i diskSn | wc -l)
        originalInfo="${originalInfo}""command:/opt/dsware/client/bin/dswareTool.sh --op queryStorageNodeInfo -id ${pool_id}  | grep -i diskSn | wc -l\n"
        originalInfo="${originalInfo}""result:osd_disk_num=${osd_disk_num}\n"
        log INFO "osd_disk_num=${osd_disk_num}"

        originalInfo="${originalInfo}""command:get iops from db""\n"

        # 获取对应pool_id的最大写IOPS值
        get_max_iops_value "${pool_id}" "PMD_POOL_W_S_"
        if [[ $? -eq 1 ]]
        then
            resultCode=1
            errorKey="${checkItemId}0004"  # 0004  无写IOPS数据表，获取写IOPS最大值失败
            originalInfo="${originalInfo}""result:there is no write iops info, can not get the max value of write iops."
            log ERROR "${checkItemId}FSM_check_iops:there is no write iops info, can not get the max value of write iops."
            log ERROR "${checkItemId}:FSM_check_iops:unok"
            return 1
        fi

        # 获取对应pool_id的最大读IOPS值
        get_max_iops_value "${pool_id}" "PMD_POOL_R_S_"
        if [[ $? -eq 1 ]]
        then
            resultCode=1
            errorKey="${checkItemId}0005"  # 0005  无读IOPS数据表，获取写IOPS最大值失败
            originalInfo="${originalInfo}""result:there is no read iops info, can not get the max value of read iops."
            log ERROR "${checkItemId}FSM_check_iops:there is no read iops info, can not get the max value of read iops."
            log ERROR "${checkItemId}FSM_check_iops:unok"
            return 1
        fi

        # 根据公式计算，盘IOPS数值
        disk_iops=$(awk "BEGIN{print ${max_write_iops_value} * ${replicationFactor} + ${max_read_iops_value} }")
        disk_iops=$(awk "BEGIN{print ${disk_iops} / ${osd_disk_num} }")
        log INFO "disk_iops=${disk_iops}"

        originalInfo="${originalInfo}""command:disk_iops=(max_write_iops_value * replicationFactor + max_read_iops_value) / osd_disk_num\n"
        originalInfo="${originalInfo}""equal to:disk_iops=(${max_write_iops_value} * ${replicationFactor} + ${max_read_iops_value}) / ${osd_disk_num}\n"
        originalInfo="${originalInfo}""review:disk_iops=${disk_iops}\n"

        if [[ $(echo "100 ${disk_iops}" | awk '{if($1>=$2) {print 1} else {print 0}}') -eq 1 ]]
        then
            originalInfo="${originalInfo}""result:(pool_id=${pool_id}) disk_iops value is less than 100.\n"
            log INFO "${checkItemId}-FSM_check_iops:(pool_id=${pool_id}) disk_iops value is less than 100."
        elif [[ $(echo "300 ${disk_iops}" | awk '{if($1>$2) {print 1} else {print 0}}') -eq 1 ]]
        then
            resultCode=1
            if [[ -z "${errorKey}" ]]
            then
                errorKey="${checkItemId}0001"
            fi
            originalInfo="${originalInfo}""result:(pool_id=${pool_id}) disk_iops value is great than 100, but value is less than 300.\n"
            log ERROR "${checkItemId}-FSM_check_iops:(pool_id=${pool_id}) disk_iops value is great than 100, but value is less than 300."
            error_info="${error_info}""(pool_id=${pool_id}) disk_iops value is great than 100, but value is less than 300.\n"
        elif [[ $(echo "500 ${disk_iops}" | awk '{if($1>$2) {print 1} else {print 0}}') -eq 1 ]]
        then
            resultCode=1
            error_num="${checkItemId}0002"
            if [[ ${error_num} -gt ${errorKey} ]]
            then
                errorKey=${error_num}
            fi
            originalInfo="${originalInfo}""result:(pool_id=${pool_id}) disk_iops value is great than 300, but value is less than 500.\n"
            log ERROR "${checkItemId}-FSM_check_iops:(pool_id=${pool_id}) disk_iops value is great than 300, but value is less than 500."
            error_info="${error_info}""(pool_id=${pool_id}) disk_iops value is great than 300, but value is less than 500.\n"
        else
            resultCode=1
            error_num="${checkItemId}0003"
            if [[ ${error_num} -gt ${errorKey} ]]
            then
                errorKey=${error_num}
            fi
            originalInfo="${originalInfo}""result:(pool_id=${pool_id}) disk_iops value is great than 500.\n"
            log ERROR "${checkItemId}-FSM_check_iops:(pool_id=${pool_id}) disk_iops value is great than 500."
            error_info="${error_info}""(pool_id=${pool_id}) disk_iops value is great than 500.\n"
        fi
    done

    if [[ ${resultCode} -eq 0 ]]
    then
        originalInfo="${originalInfo}""\n""result:all pool(s) is/are normall."
        log INFO "FSM_check_iops:all pool(s) iops is/are normall."
        return 0
    else
        originalInfo="${originalInfo}""\n""error_total:\n${error_info}"
        log ERROR "FSM_check_iops.sh:unok"
        return 1
    fi
}

function main
{
    check_main
    FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return "${resultCode}"
}

# --------------------------------------------------------------------------- #
#                          脚本开始运行
# --------------------------------------------------------------------------- #
log MUST "enter [$0],para=[$@]"
# 数据库密码
declare db_password="$(GetDBPassword | awk '{print $1}')"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}