#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

#输出到json文件中的checkItemId,每个检查脚本一个id
checkItemId="66"
resultCode=0
errorKey=""
params=""
originalInfo=""

#获取源版本
src_version="$(get_src_version)"

tar_version="$(get_package_version)"

function check_main()
{
    suse_release_file="/etc/SuSE-release"
    if [[ ! -f "${suse_release_file}" ]]
    then
        originalInfo="Not a SUSE os. No need to check."
        log INFO "${originalInfo}"
        return 0
    fi

    VERSION=$(cat ${suse_release_file} | grep "VERSION" | awk -F "=" '{print $2}' | sed 's/ //g')
    PATCHLEVEL=$(cat ${suse_release_file} | grep "PATCHLEVEL" | awk -F "=" '{print $2}' | sed 's/ //g')

    originalInfo="command:cat ${suse_release_file}""\n""review:$(cat ${suse_release_file})"
    if [[ "${VERSION}" -eq 11 && "${PATCHLEVEL}" -eq 4 ]]
    then
        log ERROR "SUSE os is 11.4"
        resultCode=1
        errorKey="${checkItemId}0001"
    fi

    conntrack_num=$(iptables -S | grep '\-A INPUT \-m conntrack \-\-ctstate RELATED,ESTABLISHED \-j ACCEPT' | wc -l)
    if [[ "${resultCode}" -eq 1 && "${src_version}" == V100R006C30* && ${conntrack_num} -gt 5 ]]
    then
        log ERROR "repeating conntrack rules in iptables, conntrack_num=${conntrack_num}"
        originalInfo=${originalInfo}"\n""command:iptables -S | grep conntrack | grep 'ctstate RELATED,ESTABLISHED' | wc -l""\n""review:${conntrack_num}"
        errorKey="${checkItemId}0002"
    fi

    return "${resultCode}"
}

function main()
{
    if [[ "${tar_version}" == V100R006C30SP[CH]5* || "${tar_version}" == "V100R006C30SPC600" ]]
    then
        log INFO "Target version is ${tar_version}, begin to check repeating rules in iptables."
        check_main
    else
        originalInfo="Target version is ${tar_version}, no need to check."
        log INFO "${originalInfo}"
    fi

    FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return "${resultCode}"
}

# --------------------------------------------------------------------------- #
#                          脚本开始运行
# --------------------------------------------------------------------------- #
log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
