#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

checkItemId="12"
resultCode=0
errorKey=""
params=""
originalInfo=""

main()
{

    lock_flag=`cat /opt/dsware/manager/webapps/dsware/WEB-INF/lockForDSwareService.properties |grep -i FreeToLock -c`
    originalInfo="command:cat /opt/dsware/manager/webapps/dsware/WEB-INF/lockForDSwareService.properties |grep -i FreeToLock -c\n"
    originalInfo="${originalInfo}""review:${lock_flag}\n"

    if [ $lock_flag -eq 0 ]
    then
        originalInfo="${originalInfo}""result:The lock file flag check is ok."
        log INFO "${checkItemId}:FSM_check_lock_file.sh:ok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    else
        resultCode=1
        errorKey="${checkItemId}0001"    #  0001 集群锁标记为 FreeToLock
        originalInfo="${originalInfo}""result:The lock flag is FreeToLock."
        log ERROR "${checkItemId}FSM_check_lock_file.sh:The lock flag is FreeToLock."
        log ERROR "${checkItemId}:FSM_check_lock_file.sh:unok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001 集群锁标记为 FreeToLock
#
##############################