#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

checkItemId="10"
resultCode=0
errorKey=""
params=""
originalInfo=""

main()
{

    #/var/log/daemon.log 日志大小超过500M就报错
    #/var/log/messages 日志大小超过500M就报错

    local daemon_log="/var/log/daemon.log"
    local message_log="/var/log/messages"
    local STANDARD=$((500*1024))
    error_daemon_num=0
    error_messages=0
    
    if [[ -f "${daemon_log}" ]]
    then
        daemon_log_size=$(du -sk "${daemon_log}"| awk '{print $1}')
        originalInfo="${originalInfo}""command:du -sk ${daemon_log} | awk '{print \$1}'\n"
        originalInfo="${originalInfo}""review:${daemon_log} size is ${daemon_log_size}K\n"
        if [ ${daemon_log_size} -gt ${STANDARD} ]
        then
            resultCode=1
            error_daemon_num=1
            originalInfo="${originalInfo}""result:${daemon_log} size is more than 500M\n"
            log ERROR "${checkItemId}FSM_check_log_size.sh:${daemon_log} size is more than 500M"
        fi
    fi

    if [[ -f "${message_log}" ]]
    then
        messages_size=$(du -sk "${message_log}"| awk '{print $1}')
        originalInfo="${originalInfo}""command:du -sk ${message_log}| awk '{print \$1}'\n"
        originalInfo="${originalInfo}""review:${message_log} size is ${messages_size}K\n"
        if [ ${messages_size} -gt ${STANDARD} ]
        then
            resultCode=1
            error_messages=2
            originalInfo="${originalInfo}""result:${message_log} size is more than 500M"
            log ERROR "${checkItemId}FSM_check_log_size.sh:${message_log} size is more than 500M"
        fi
    fi

    if [ ${resultCode} -eq 1 ]
    then
        errorKey="${checkItemId}0000"
        error_total=$[${error_daemon_num}+${error_messages}]
        errorKey=$[${errorKey}+${error_total}]
        log ERROR "${checkItemId}:FSM_check_log_size.sh:unok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    else
        originalInfo="${originalInfo}""result:FSM daemon.log and messages log szie is ok."
        log INFO "${checkItemId}:FSM_check_log_size.sh:ok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001 daemon.log                   日志大小超过了500M
#  0002 message.log                  日志大小超过了500M
#  0003 daemon.log 和 message.log    日志大小超过了500M
#
##############################