#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/func.sh"|| { log ERROR "source ${UPG_LIB_PATH}/func.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

#输出到json文件中的checkItemId,每个检查脚本一个id
checkItemId="14"
resultCode=0
errorKey=""
params=""
originalInfo=""

declare TMP_ALL_SERVER_INFO_FILE="/tmp/all_server_info_pre"
declare TMP_MDC_SERVER_INFO_FILE="/tmp/mdc_server_info_pre"
declare TMP_ZK_SERVER_INFO_FILE="/tmp/zk_server_info_pre"
declare TMP_POOL_SERVER_INFO_FILE="/tmp/pool_server_info_pre"
declare TMP_VBS_SERVER_INFO_FILE="/tmp/vbs_server_info_pre"
declare TMP_KVS_SERVER_INFO_FILE="/tmp/kvs_server_info_pre"

function get_all_server_info()
{
    log INFO "Begin to get info from TBL_SERVER_INFO."
    local sql_server_info="select ID,MANAGEIP from TBL_SERVER_INFO;"
    all_server_info="$(echo $DBPASSWORD | xargs -i su - omm -c "gsql -p 21600 -W {} -t -c 'set search_path=dsware_1;${sql_server_info}'"|sed 's/ //g')"
    ret=$?
    if [[ "${ret}" -ne 0 || -z "${all_server_info}" ]]; then
        log ERROR "Fail to get info from TBL_SERVER_INFO."
        originalInfo="command: echo db_password | xargs -i  su - omm -c \\\"gsql -p 21600 -W {} -t -c 'set search_path=dsware_1;${sql_server_info}'\\\"""\n""ERROR:Fail to get info from TBL_SERVER_INFO.""\n"
        resultCode=1
        errorKey="140001"
        return 1
    fi
    echo "${all_server_info}" > "${TMP_ALL_SERVER_INFO_FILE}"
    fsync "${TMP_ALL_SERVER_INFO_FILE}"
    log INOF "Get info from TBL_SERVER_INFO successfully."
    return 0
}

function get_server_info_by_role()
{
    local tbl_name=$1
    local result_file_name=$2

    log INFO "Begin to get info from ${tbl_name}."
    local sql_role_server_info="select SERVERID from ${tbl_name};"
    role_server_info="$(echo $DBPASSWORD | xargs -i su - omm -c "gsql -p 21600 -W {} -t -c 'set search_path=dsware_1;${sql_role_server_info}'"|sed 's/ //g')"
    ret=$?
    if [ "${ret}" -ne 0 ]; then
        log ERROR "Fail to get info from ${tbl_name}."
        originalInfo="${originalInfo}""command: echo \$DBPASSWORD | xargs -i su - omm -c \\\"gsql -p 21600 -W {} -t -c 'set search_path=dsware_1;${sql_role_server_info}'\\\"""\n""ERROR:Fail to get info from ${tbl_name}.""\n"
        resultCode=1
        errorKey="140001"
        return 1
    fi
    echo "${role_server_info}" > ${result_file_name}
    fsync "${result_file_name}"
    log INFO "Get info from ${tbl_name} successfully."
    return 0
}

function clear_tmp_info_file()
{
    #清理临时文件
    rm -f ${TMP_ALL_SERVER_INFO_FILE} ${TMP_MDC_SERVER_INFO_FILE} ${TMP_ZK_SERVER_INFO_FILE}
    rm -f ${TMP_POOL_SERVER_INFO_FILE} ${TMP_VBS_SERVER_INFO_FILE} ${TMP_KVS_SERVER_INFO_FILE}
}

function check_main()
{
    #获取所有节点信息
    get_all_server_info || return $?
    #根据表名，获取节点信息的SERVERID
    get_server_info_by_role "TBL_MDC_SERVER_INFO" "${TMP_MDC_SERVER_INFO_FILE}" || return $?
    get_server_info_by_role "TBL_ZK_SERVER_INFO" "${TMP_ZK_SERVER_INFO_FILE}" || return $?
    get_server_info_by_role "TBL_POOL_SERVER_INFO" "${TMP_POOL_SERVER_INFO_FILE}" || return $?
    get_server_info_by_role "TBL_VBS_INFO" "${TMP_VBS_SERVER_INFO_FILE}" || return $?
    get_server_info_by_role "TBL_KVS_INFO" "${TMP_KVS_SERVER_INFO_FILE}"|| return $?

    #开始检查
    log INFO "Begin to check ..."
    error_ip=""
    while read line
    do
        server_id="$(echo "${line}" |awk -F'|' '{print $1}'|sed 's/ //g')"
        node_ip="$(echo "${line}" |awk -F'|' '{print $2}'|sed 's/ //g')"
        id_in_mdc="$(grep -w ${server_id} "${TMP_MDC_SERVER_INFO_FILE}")"
        id_in_zk="$(grep -w ${server_id} "${TMP_ZK_SERVER_INFO_FILE}")"
        id_in_pool="$(grep -w ${server_id} "${TMP_POOL_SERVER_INFO_FILE}")"
        id_in_vbs="$(grep -w ${server_id} "${TMP_VBS_SERVER_INFO_FILE}")"
        id_in_kvs="$(grep -w ${server_id} "${TMP_KVS_SERVER_INFO_FILE}")"

        if [[ -z "${id_in_vbs}" && -z "${id_in_kvs}" && -z "${id_in_mdc}" && -z "${id_in_zk}" && -z "${id_in_pool}" ]]
        then
            error_ip="${node_ip}"";""${error_ip}"
        fi
    done < ${TMP_ALL_SERVER_INFO_FILE}

    clear_tmp_info_file

    if [[ -n "${error_ip}" ]]
    then
        log ERROR "Nodes do not deploy mdc/zk/osd/vbs/kvs. Nodes ip:${error_ip}"
        originalInfo="Nodes do not deploy mdc/zk/osd/vbs/kvs. Nodes ip:${error_ip}"
        resultCode=1
        errorKey="140002"
        params="${error_ip}"
        return 1
    fi
    log INFO "Check non role node successfully."
    originalInfo="Check non role node successfully."
    return 0
}

function main()
{
    check_main

    FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return "${resultCode}"
}

# --------------------------------------------------------------------------- #
#                          脚本开始运行
# --------------------------------------------------------------------------- #
log MUST "enter [$0],para=[$@]"

# 数据库密码
declare DBPASSWORD="$(GetDBPassword | awk '{print $1}')"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
