#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
source "${UPG_LIB_PATH}/func.sh"|| { log ERROR "source ${UPG_LIB_PATH}/func.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

checkItemId="68"
resultCode=0
errorKey=""
params=""
originalInfo=""

function checkNvdimmCache()
{
    log INFO "Begin to get info from TBL_STORAGE_POOL_INFO."
    local query_cache_sql="select CACHEMEDIATYPE from TBL_STORAGE_POOL_INFO;"
    local all_cache_info="$(echo $DBPASSWORD | xargs -i su - omm -c "gsql -p 21600 -W {} -t -c 'set search_path=dsware_1;${query_cache_sql}'"|sed 's/ //g')"
    ret=$?
    if [[ "${ret}" -ne 0 || -z "${all_cache_info}" ]]; then
        log ERROR "Fail to get info from TBL_SERVER_INFO."
        originalInfo="command: echo $DBPASSWORD | xargs -i su - omm -c \\\"gsql -p 21600 -W {} -t -c 'set search_path=dsware_1;${query_cache_sql}'\\\"""\n""ERROR:Fail to get info from TBL_STORAGE_POOL_INFO.""\n"
        resultCode=1
        errorKey="${checkItemId}0001"
        return 1
    fi
	local nvdimm_result="$(echo $all_cache_info | grep -i nvdimm)"
	if [ -n "${nvdimm_result}" ];
    then
        log ERROR "There has nvdimm in the pool."
		originalInfo="There has nvdimm in the pool."
		resultCode=1
        errorKey="${checkItemId}0002"
		return 1
    fi
	log INOF "Get info from TBL_STORAGE_POOL_INFO successfully."
	return 0
}

function main()
{
    checkNvdimmCache
	FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return "${resultCode}"
}


# --------------------------------------------------------------------------- #
#                          脚本开始运行
# --------------------------------------------------------------------------- #
log MUST "enter [$0],para=[$@]"
# 数据库密码
declare DBPASSWORD="$(GetDBPassword | awk '{print $1}')"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}