#!/bin/bash

#############################################################
#
# 名  称：检查是否更换过omm证书
# 错误码：
#         0001 application.properties 文件不存在
#         0002 omm证书被替换过
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="75"
resultCode=0
errorKey=""
params=""
originalInfo=""


# --------------------------------------------------------------------------- #
#                          全局变量
# --------------------------------------------------------------------------- #
declare OMS_RUN_PATH="/opt/omm/oms"
declare g_confResPathOld="${OMS_RUN_PATH}/workspace/conf"
declare g_property_file="${g_confResPathOld}/fms/application.properties"

function main()
{
    # 文件不存在
    if [ ! -f "${g_property_file}" ]; then
        log ERROR "File[${g_property_file}] not exist, please check."
        resultCode=1
        errorKey="${checkItemId}0001"
        originalInfo="File[${g_property_file}] not exist, please check."
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    # 判断用户升级前是否替换过SSL证书。 依据: 证书配置文件中的证书文件名是否包含“default”关键字
    originalInfo="${originalInfo}command:
    grep -rn \\\"KeyStore=\\\" ${g_property_file} | grep \\\"default\\\"
    grep -rn \\\"TrustStore=\\\" ${g_property_file} | grep \\\"default\\\"\n"

    grep -rn "KeyStore=" ${g_property_file} | grep "default"
    check_keystore=$?
    grep -rn "TrustStore=" ${g_property_file} | grep "default"
    check_truststore=$?

    if [ ${check_keystore} -ne 0 -o ${check_truststore} -ne 0 ]; then
        log ERROR "The OMS certificate has been replaced."
        resultCode=1
        errorKey="${checkItemId}0002"
        originalInfo="${originalInfo}result:1\n"
        originalInfo="${originalInfo}detail:The OMM certificate has been replaced. If you perform the upgrade and then perform the capacity expansion, the capacity expansion will fail."
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi
    originalInfo="${originalInfo}result:0\n"
    originalInfo="${originalInfo}detail:The OMM certificate has not been replaced."

    log INFO "${checkItemId}:FSM_check_oms_certificate.sh:ok"
    FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return 0
}


log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}