#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

#输出到json文件中的checkItemId,每个检查脚本一个id
checkItemId="1"

##############################################################
## @Usage get_HA_Mode()
## @Description 获取本机HA的模式
##############################################################
function get_HA_Mode()
{
    local haConfig="/opt/omm/oms/workspace/ha/module/hacom/conf/hacom.xml"
    if [ ! -f "${haConfig}" ]; then
        error_info="${haConfig} not exist, can not get HA mode."
        log ERROR "${error_info}"
        return 1
    fi

    # 从配置文件中读取当前fsm的安装模式
    hamode=$(grep -w "hamode value" "$haConfig" | awk -F'"' '{print $2}')
    if [ "${hamode}" != "double" -a "${hamode}" != "single" ];then
        error_info="Hamode is illegal. Get hamode is ${hamode}, from $haConfig."
        log ERROR "${error_info}"
        return 1
    fi

    log INFO "Get hamode=${hamode}"

    #检查status_ha.sh脚本是否存在
    if [ ! -f "${OMM_HA_STATUS_CMD}" ]
    then
        error_info="${OMM_HA_STATUS_CMD} not exist."
        log ERROR "${error_info}"
        return 1
    fi

    return 0
}

##############################################################
## @Usage check_HA_status
## @Return 0 :
## @Description 检查HA监控的资源状态
##############################################################
function check_HA_status()
{
    # 在主控上检查两端状态是否正常
    local statusResult=$(${OMM_HA_STATUS_CMD} 2>&1 | sed  '/^$/d' | tr -s " " | sed 's/ /\t/g')

    # 检查是否有资源处于Non_Steady状态
    local noSteadyRes=$(echo "${statusResult}" | awk -v state="Non_steady" '{if ($4==state) {print $0} }')
    if [ -n "${noSteadyRes}" ];then
        log ERROR "Some resource is no steady. [${noSteadyRes}]"
        return 1
    fi

    local LocS=$(echo "${statusResult}" | awk -v ROLE="active" '{if ($6==ROLE) {printf("%s\n",$7);}}')
    if [ "${hamode}" = "double" ]; then
        local PeerS=$(echo "${statusResult}" | awk -v ROLE="standby" '{if ($6==ROLE) {printf("%s\n",$7);}}')
        if [ "${LocS}" != "normal" -o "${PeerS}" != "normal" ]; then
            log ERROR "abnormal resource [$(${OMM_HA_STATUS_CMD} 2>&1 | grep -v Normal)]"
            return 1
        fi
    else
        if [ "${LocS}" != "normal" ]; then
            log ERROR "HA res state[loca ${LocS}]."
            log ERROR "abnormal resource [$(${OMM_HA_STATUS_CMD} 2>&1 | grep -v Normal)]"
            return 1
        fi
    fi

    return 0
}

function main()
{
    get_HA_Mode
    ret=$?
    if [[ "${ret}" -ne 0 ]]; then
        resultCode=1
        errorKey="10001"
        params=""
        originalInfo="${error_info}"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    #HA资源状态检查
    declare -i count=0
    for temp in {1..5}
    do
        check_HA_status
        ret=$?
        if [ "$ret" -ne 0 ]
        then
            ((count++))
        fi
        sleep 1
    done

    if [[ "$ret" -ne 0 && "${count}" -gt 2 ]]
    then
        log ERROR "HA resource is abnormal. check count=${count}."
		error_info="$(${OMM_HA_STATUS_CMD} 2>&1 | grep -E "Abnormal|Unknown|Exception|Non_steady")"
		resultCode=1
        errorKey="10002"
        params=""
        originalInfo="sh ${OMM_HA_STATUS_CMD} 2>&1 | grep -E \\\"Abnormal|Unknown|Exception|Non_steady\\\"""\n${error_info}"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    info="$(${OMM_HA_STATUS_CMD} 2>&1)"
    resultCode=0
    errorKey=""
    params=""
    originalInfo="sh ${OMM_HA_STATUS_CMD} 2>&1""\n${info}"
    FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    log INFO "Check oms status successfully."
    return 0

}

# --------------------------------------------------------------------------- #
#                          全局变量
# --------------------------------------------------------------------------- #
declare OMM_HA_STATUS_CMD="/opt/omm/oms/workspace/ha/module/hacom/script/status_ha.sh"
declare hamode=""
declare error_info=""

# --------------------------------------------------------------------------- #
#                          脚本开始运行
# --------------------------------------------------------------------------- #
log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
