#!/bin/bash
##############################################################
## 检查机柜级安全级别下，机柜中服务器数量最大最小的差值是否大于2
## 0001 获取数据库密码失败。 Failed to obtain the database password.
## 0002 存储池的机柜中服务器数量最大最小的差值大于2
## 0003 sql执行失败
##############################################################
UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/func.sh"|| { log ERROR "source ${UPG_LIB_PATH}/func.sh failed."; exit 130; }
[ -z "${OMS_RUN_PATH}" ] && OMS_RUN_PATH="/opt/omm/oms"

# --------------------------------------------------------------------------- #
#                          全局变量
# --------------------------------------------------------------------------- #
#输出到json文件中的checkItemId,每个检查脚本一个id
checkItemId="76"
resultCode=0
errorKey=""
params=""
originalInfo=""

function main()
{
    # 1.源版本为C30之前版本，目标版本为C30版本
    src_version="$(get_src_version)"
    target_version="$(get_package_version)"
    log INFO "src_version = ${src_version}"
    # 源版为C30，pass,或者目标版本不为C30,pass
    if [[ ${src_version} =~ V100R006C30 ]] || [[ ! ${target_version} =~ V100R006C30 ]]
    then
        log INFO "Src Version(${src_version}) to Target Version(${target_version}) no need check, Pass!"
        originalInfo="Src Version(${src_version}) to Target Version(${target_version}) no need check, Pass!"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    # 2.获取密码成功
    db_password="$(GetDBPassword | awk '{print $1}')"
    if [ -z "${db_password}" ]
    then
        log ERROR "Failed to obtain the database password."
        originalInfo="Failed to obtain the database password."
        resultCode=1
        errorKey="${checkItemId}0001"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    # 3.检查机柜级安全模式
    #存储池ID与安全级别pool_sec=(0 | server 1 | rack)
    pool_secs=($(echo ${db_password} | xargs -i su - omm -c "gsql -p 21600 -W {} -XAtc 'set search_path=dsware_1;\
select POOLID,SECURITYLEVEL from TBL_STORAGE_POOL_INFO;'"))

    originalInfo="Command:su - omm -c \\\"gsql -p 21600 -W **** -XAtc 'set search_path=dsware_1;\
select POOLID,SECURITYLEVEL from TBL_STORAGE_POOL_INFO;'\\\"\n"
    originalInfo="${originalInfo}""Result:\n${pool_secs[@]} \n\n"

    if [ ${#pool_secs[@]} -eq 0 ]
    then
        log ERROR "Failed to exec the sql."
        originalInfo="${originalInfo}""Failed to exec the sql."
        resultCode=1
        errorKey="${checkItemId}0003"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    ser_num_flag=0
    for((i=0;i<${#pool_secs[@]};i++))
    do 
        #id和类型成对
        local poolid=$(echo ${pool_secs[$i]} | awk -F '|' '{print $1}')
        local sec_level=$(echo ${pool_secs[$i]} | awk -F '|' '{print $2}')
        if [[ "${sec_level}" == "rack" ]]
        then
            # 根据poolid分类查询机柜服务器数量
            rack_count=($(echo ${db_password} | xargs -i su - omm -c "gsql -p 21600 -W {} -XAtc 'set search_path=dsware_1;\
select t2.RACKID, count(1) \
from TBL_POOL_SERVER_INFO as t1 \
left join TBL_SERVER_INFO as t2 \
on t1.SERVERID=t2.ID \
where t1.POOLID=${poolid} \
group by t2.RACKID;'"))

            originalInfo="${originalInfo}""Command:su - omm -c \\\"gsql -p 21600 -W **** -XAtc 'set search_path=dsware_1;\
select t2.RACKID, count(1) \
from TBL_POOL_SERVER_INFO as t1 \
left join TBL_SERVER_INFO as t2 \
on t1.SERVERID=t2.ID \
where t1.POOLID=${poolid} \
group by t2.RACKID;'\\\"\nResult:\n"
            originalInfo="${originalInfo}""PoolID:${poolid}\n"
            if [ ${#rack_count[@]} -eq 0 ]
            then
                originalInfo="${originalInfo}""result is NULL.\n\n"
                log INFO "Pool(${poolid}) server is ERROR."
                continue
            fi
            originalInfo="${originalInfo}""${rack_count[@]}\n"
            # 从第一个开始初始化
            local max_ser_num=$(echo ${rack_count[0]} | awk -F '|' '{print $2}')
            local max_rock=$(echo ${rack_count[0]} | awk -F '|' '{print $1}')
            local min_ser_num=$(echo ${rack_count[0]} | awk -F '|' '{print $2}')
            local min_rock=$(echo ${rack_count[0]} | awk -F '|' '{print $1}')
            # 每3个为一组数据
            for((j=0;j<${#rack_count[@]};j++))
            do
                local rack=$(echo ${rack_count[j]} | awk -F '|' '{print $1}')
                local count=$(echo ${rack_count[j]} | awk -F '|' '{print $2}')
                log INFO "rack [${rack}] has ${count} server."
                if [ $count -gt $max_ser_num ]
                then
                    max_ser_num=$count
                    max_rock=${rack}
                fi
                if [ $count -lt $min_ser_num ]
                then
                    min_ser_num=$count
                    min_rock=${rack}
                fi
            done
            # 当机柜服务器数量大于2
            local caculate=$(expr ${max_ser_num} - ${min_ser_num})
            if [ ${caculate} -gt 2 ]
            then
                ser_num_flag=1
                originalInfo="${originalInfo}""Pool ${poolid} Not Meets the Rack Level Security Requirements\n"
            fi
            # 末尾多一个空格分隔开
            originalInfo="${originalInfo}""\n"
        fi
    done

    if [ ${ser_num_flag} -ne 0 ]
    then
        log ERROR "The storage pool contains cabinets that do not meet the cabinet-level security requirements."
        resultCode=1
        errorKey="${checkItemId}0002"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    log INFO "All rack meet the security-level requirements, Pass!"
    originalInfo="${originalInfo}""All rack meet the security-level requirements, Pass!"
    FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return 0
}

# --------------------------------------------------------------------------- #
#                          脚本开始运行
# --------------------------------------------------------------------------- #
log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}