#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/dswareTool_lib.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/dswareTool_lib.sh failed."; exit 130; }

#输出到json文件中的checkItemId,每个检查脚本一个id
checkItemId="6"
resultCode=0
errorKey=""
params=""
originalInfo=""


function main()
{
    storage_pool_info=`run_dswaretool queryStoragePool`
    originalInfo="${originalInfo}""command:run_dswaretool queryStoragePool\n"
    log INFO "${storage_pool_info}"
    pool_id=`echo "${storage_pool_info}" | grep -E '^[0-9]+' | awk '{print$1}'`
    originalInfo="${originalInfo}""result:pool_id=${pool_id}\n"

    pool_id_equal_0_judg="0"
    if [[ $(get_src_version) =~ V100R006C[12]0 ]]
    then
        log INFO "Begin to check pool id."
        pool_id_equal_0_judg=`echo "${pool_id}" | grep -w 0`
    fi

    error_info=""
    for i in ${pool_id}
    do 
        paras="-id $i"
        S=`run_dswaretool queryStorageNodeInfo "$paras" | grep "nodeMgrIp" -c`
        originalInfo="${originalInfo}""command:run_dswaretool queryStorageNodeInfo -id $i | grep nodeMgrIp -c\n"
        originalInfo="${originalInfo}""review:${S}\n"
        if [[ $(get_src_version) =~ V100R006C[123]0 || $(get_src_version) == V100R006C00SPC103 ]]
        then
            T=`echo "${storage_pool_info}" | grep -wE "^${i}" | awk '{print $4}'`
            originalInfo="${originalInfo}""command:echo \$storage_pool_info | grep -wE ^\${i} | awk '{print \$4}'\n"
            originalInfo="${originalInfo}""review:T=${T}\n"
            U=`echo "${storage_pool_info}" | grep -wE "^${i}" | awk '{print $5}'`
            originalInfo="${originalInfo}""command:echo \$storage_pool_info | grep -wE ^\${i} | awk '{print \$5}'\n"
            originalInfo="${originalInfo}""review:U=${U}\n"
        else
            T=`echo "${storage_pool_info}" | grep -wE "^${i}" | awk '{print $3}'`
            originalInfo="${originalInfo}""command:echo \$storage_pool_info | grep -wE ^\${i} | awk '{print \$3}'\n"
            originalInfo="${originalInfo}""review:T=${T}\n"
            U=`echo "${storage_pool_info}" | grep -wE "^${i}" | awk '{print $4}'`
            originalInfo="${originalInfo}""command:echo \$storage_pool_info | grep -wE ^\${i} | awk '{print \$5}'\n"
            originalInfo="${originalInfo}""review:U=${U}\n"
        fi
       
        result_tmp=$(awk 'BEGIN{printf "%.2f\n",('$U'/('$T'-'$T'/'$S'))}')
        originalInfo="${originalInfo}""command:percent=U/(T-T/S)\n"
        result=$(awk 'BEGIN{printf "%d\n",'${result_tmp}*100'}')
        originalInfo="${originalInfo}""review:percent=${result_tmp}\n"
        
        if [[ $result -gt 85 ]]
        then
            resultCode=1
            params="${params}""${i} "        ##表示不满足要求的存储池id
            originalInfo="${originalInfo}""result:poolId=${i},usage=${result}%\n"
            error_info="${error_info}""poolId=${i},usage=${result}%;"
        fi
    done

    if [[ -n "${error_info}" ]] && [[ -n "${pool_id_equal_0_judg}" ]]
    then
        resultCode=1
        errorKey="${checkItemId}0001"   ##60001存储池容量不满足升级要求
        originalInfo="${originalInfo}""result:Storage pool usage more than 85% , include:${error_info}"
        log ERROR "${checkItemId}FSM_check_pool_space.sh:Storage pool usage more than 85% , include:${error_info}"
        log ERROR "${checkItemId}:FSM_check_pool_space.sh:unok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" " ${params}" "${originalInfo}"
        return 1
    elif [[ -z "${error_info}" ]] && [[ -z "${pool_id_equal_0_judg}" ]]
    then
        resultCode=1
        errorKey="${checkItemId}0002"  #0002 集群中无id为0的存储池
        originalInfo="${originalInfo}""result:there is no pool_id equal 0 in the cluster."
        log ERROR "FSM_check_pool_space:there is no pool_id equal 0 in the cluster."
        log ERROR "FSM_check_pool_space:unok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    elif [[ -n "${error_info}" ]] && [[ -z "${pool_id_equal_0_judg}" ]]
    then
        resultCode=1
        errorKey="${checkItemId}0003"  #0003 集群中无id为0的存储池,且存在存储池容量不满足升级要求
        originalInfo="${originalInfo}""result:there is no pool_id equal 0 in the cluster, and storage pool usage more than 85% , include:${error_info}."
        log ERROR "FSM_check_pool_space:there is no pool_id equal 0 in the cluster, and storage pool usage more than 85% , include:${error_info}."
        log ERROR "FSM_check_pool_space:unok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    else
        originalInfo="${originalInfo}""result:there is no Storage pool usage more than 85%, and there is pool_id=0."
        log INFO "${checkItemId}:FSM_check_pool_space.sh:ok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

}


log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
