#!/bin/bash

#############################################################
#
# 名  称：检查RemoveIPC配置
# 错误码：
#         0000 正常
#         0001 /etc/systemd/logind.conf 文件中存在配置：RemoveIPC=yes
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

checkItemId="64"
resultCode=0
errorKey=""
params=""
originalInfo=""

function main()
{
    os_release=$(cat /etc/*-release | grep -v "\""| grep -v '\\')
    originalInfo="${originalInfo}""command:cat /etc/*-release \n"
    originalInfo="${originalInfo}""Important information:${os_release}\n"

    cat /proc/version | grep -iE "oracle|centos|redhat" >/dev/null 2>&1
    ret=$?
    if [ ${ret} != 0 ]
    then
        originalInfo="${originalInfo}""result:this node_OS is not RedHat or CentOS or Oracle."
        log INFO "${checkItemId}FSM_check_removeIPC.sh:this node_OS is not RedHat or CentOS or Oracle."
        log INFO "${checkItemId}:FSM_check_removeIPC.sh:ok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    conf_file="/etc/systemd/logind.conf"

    if [ ! -f "${conf_file}" ]
    then
        originalInfo="${originalInfo}""result:there is no ${conf_file} file, no need to check."
        log INFO "${checkItemId}FSM_check_removeIPC.sh: there is no ${conf_file} file."
        log INFO "${checkItemId}:FSM_check_removeIPC.sh:ok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    removeIPC_status=`cat ${conf_file} | grep -i 'RemoveIPC'`
    originalInfo="${originalInfo}""command:cat ${conf_file} | grep -i 'RemoveIPC'\n"
    originalInfo="${originalInfo}""review:${removeIPC_status}\n"
    if [[ -z "${removeIPC_status}" ]]
    then
        originalInfo="${originalInfo}""result:this node_OS is RedHat or CentOS or Oracle, and there is ${conf_file} file, but there is no key_word which is RemoveIPC."
        log INFO "${checkItemId}FSM_check_removeIPC.sh:this node_OS is RedHat or CentOS or Oracle, and there is ${conf_file} file, but there is no key_word which is RemoveIPC."
        log INFO "${checkItemId}:FSM_check_removeIPC.sh:ok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    RemoveIPC_judg=`cat ${conf_file} | grep -i 'RemoveIPC' | awk -F '=' '{print$2}'`

    if [[ "${RemoveIPC_judg}"x == "yes"x ]]
    then
        resultCode=1
        errorKey="${checkItemId}0001" # /etc/systemd/logind.conf 文件中存在配置：RemoveIPC=yes
        originalInfo="${originalInfo}""result:there is key_word which is RemoveIPC=yes in ${conf_file}."
        log ERROR "${checkItemId}FSM_check_removeIPC.sh:there is key_word which is RemoveIPC=yes in ${conf_file}."
        log ERROR "${checkItemId}:FSM_check_removeIPC.sh:unok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    else
        originalInfo="${originalInfo}""result:this node_OS is RedHat or CentOS or Oracle, and there is ${conf_file} file, but RemoveIPC is not equal yes."
        log INFO "${checkItemId}FSM_check_removeIPC.sh:this node_OS is RedHat or CentOS or Oracle, and there is ${conf_file} file, but RemoveIPC is not equal yes."
        log INFO "${checkItemId}:FSM_check_removeIPC.sh:ok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
