#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/dswareTool_lib.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/dswareTool_lib.sh failed."; exit 130; }

#输出到json文件中的checkItemId,每个检查脚本一个id
checkItemId="56"
resultCode=0
errorKey=""
params=""
originalInfo=""

#获取源版本
src_version="$(get_src_version)"

function check_main()
{
    backup_server_info=$(run_dswaretool queryBackupServer)
    ret=$?
    log INFO "${backup_server_info}"

    originalInfo="run_dswaretool queryBackupServer \n"

    if [[ ${ret} -ne 0 ]]
    then
        log ERROR "Failed to execute the dswareTool command.ret=${ret}.[--op queryBackupServer]"
        resultCode=1
        errorKey="${checkItemId}""0002"
        originalInfo="${originalInfo}""ERROR:Failed to query backup server. Please retry or contact technical support engineers."
        return 1
    fi

    check_result=$(echo -e "${backup_server_info}" | grep "Backup server is not configured")

    if [[ -n "${check_result}" ]]
    then
        originalInfo="${originalInfo}""review:${check_result}, check result: OK"
        log INFO "${check_result}, check result：OK"
        return 0
    fi

    server_type=$(echo -e "${backup_server_info}" | grep "Backup server type")
    originalInfo="${originalInfo}""review:${server_type}\n"

    if [[ -n "$(echo ${server_type}| grep -w "sftp")" ]]
    then
        log ERROR "${server_type}, check result：UNOK"
        resultCode=1
        errorKey="${checkItemId}""0001"
        return 1
    fi

    log INFO "${server_type}, not sftp. check result：OK"
    return 0
}

function main()
{
    if [[ ${src_version} == V100R006C30SP[CH]5* ]]
    then
        log INFO "Current version is ${src_version}, begin to check sftp backup service."
        check_main
    else
        originalInfo="Current version is ${src_version}, no need to check sftp backup service."
        log INFO "${originalInfo}"
    fi

    FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return "${resultCode}"
}

# --------------------------------------------------------------------------- #
#                          脚本开始运行
# --------------------------------------------------------------------------- #
log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
