#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/dswareTool_lib.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/dswareTool_lib.sh failed."; exit 130; }

#输出到json文件中的checkItemId,每个检查脚本一个id
checkItemId="11"
resultCode=0
errorKey=""
params=""
originalInfo=""

function main()
{
    storage_pool_info=`run_dswaretool queryStoragePool`
    pool_num_list=(`echo "${storage_pool_info}"|egrep -o "^[0-9]+"`)
    originalInfo="command:run_dswaretool queryStoragePool""\n"
    originalInfo="${originalInfo}""result:pool_num_list=${pool_num_list[@]}\n"
    log INFO "${checkItemId}:FSM_check_snapshot_num.sh:pool_num_list=${pool_num_list[@]}"

    deadline_time=`date +%Y%m%d`
    deadline_time=$[${deadline_time}-100]

    snapshot_num_error=0
    snapshot_create_error=0

    for i in ${pool_num_list[@]}
    do
        paras="-p $i"
        snapshot_info=`run_dswaretool queryAllSnapshot "$paras"`
        snapshot_zero=`echo "${snapshot_info}" | grep -i "No snapshot exist in this pool"`

        if [[ -n "${snapshot_zero}" ]]
        then
            originalInfo="${originalInfo}""result:The snapshot number of pool ${params} equit 0.\n"
            log INFO "The snapshot number of pool ${params} equit 0."
            continue
        fi

        snapshot_num=`echo "${snapshot_info}" | grep "Total snapshot number" |awk -F ':' '{print $2}' | awk -F '.' '{print $1}'`
        originalInfo="${originalInfo}""result:Pool ${i} total_snapshot_num is ${snapshot_num}\n"
        log INFO "Pool ${i} total_snapshot_num is ${snapshot_num}"
      
        if [ ${snapshot_num} -gt 20 ]
        then
           resultCode="1"
           snapshot_num_error=1
           params="$params""$i "
           originalInfo="${originalInfo}""result:The snapshot number of pool ${params} is beyond 20.\n"
           log ERROR "The snapshot number of pool ${params} is beyond 10."
        fi

        snapshots_creat_time=`cat /opt/dsware/client/conf/allSnapInfos.dat | tail +4 |awk '{print$7}' | sed 's/-//g'`
        for creat_time in ${snapshots_creat_time}
        do
            if [ "${creat_time}" -gt "${deadline_time}" ]
            then
                resultCode="1"
                snapshot_create_error=2
                params="$params""$i "
                originalInfo="${originalInfo}""result:Pool ${i} have a snapshot that is created on ${creat_time}(within one month).\n"
                log ERROR "Pool ${i} must have a snapshot that is created within one month."
                break
            fi
        done
    done
    
    if [ ${resultCode} -eq 1 ]
    then
        errorKey="${checkItemId}0000"    #  0001  存在存储池快照数量超过了20个
        errorKey=$[${errorKey}+${snapshot_num_error}+${snapshot_create_error}]
        log ERROR "${checkItemId}:FSM_check_snapshot_num.sh:unok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" " ${params}" "${originalInfo}"
        return 1
    else
        originalInfo="${originalInfo}""result:All pool snapshot num less than 20, and all snapshots creation time exceeds one month."
        log INFO "${checkItemId}:FSM_check_snapshot_num.sh:ok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}



#########################
#
#  错误码：
#    0001  存在存储池快照数量超过了20个
#    0002  有存储池存在近一月创建快照
#    0003  该集群存在超过20个快照的存储池，及有存储池中存在近一月创建快照
#
#########################