#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="65"
resultCode=0
errorKey=""
params=""
originalInfo=""

#获取升级目标版本
tar_version="$(get_package_version)"


function main()
{
    originalInfo="${originalInfo}""command:get_package_version\n"
    originalInfo="${originalInfo}""view:tar_version=${tar_version}\n"
    if [[ "${tar_version}"x == "V100R006C00SPC103"x ]]
    then
        resultCode=1
        errorKey="${checkItemId}0001"  # 0001 请查看兼容性列表确认使用的SSD盘是否在兼容性列表中，若不在，升级后会出现存储介质不兼容告警。
        originalInfo="${originalInfo}""result:Update_tar_version is V100R006C00SPC103."
        log ERROR "${checkItemId}FSM_check_storage_medium_incompatible: Update_tar_version is V100R006C00SPC103."
        log ERROR "${checkItemId}FSM_check_storage_medium_incompatible:unok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    else
        resultCode=0
        originalInfo="${originalInfo}""result:Update_tar_version is not V100R006C00SPC103, no need to check."
        log INFO "${checkItemId}FSM_check_storage_medium_incompatible:Update_tar_version is not V100R006C00SPC103, no need to check."
        log INFO "${checkItemId}FSM_check_storage_medium_incompatible:ok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

}

# --------------------------------------------------------------------------- #
#                          脚本开始运行
# --------------------------------------------------------------------------- #
log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}