#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
source "${UPG_LIB_PATH}/func.sh"|| { log ERROR "source ${UPG_LIB_PATH}/func.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

#输出到json文件中的checkItemId,每个检查脚本一个id
checkItemId="59"
resultCode=0
errorKey=""
params=""
originalInfo=""

#获取升级目标版本
tar_version="$(get_package_version)"

#默认的6.3版本数据库密文,老版本设备预置的密钥，工具配合产品
default_encrypted_password="d2NjX2NyeXB0ATQxNDU1MzVGNDM0MjQzOzM0MzEzNDQ1MzgzODM2Mzc0MTQ1MzMzMDQzMzAzMTQxMzY0MjMwMzMzMTMxNDYzNDMzNDU0NTMxNDU0NDQ2MzkzNDM2NDY0NDM5MzI0NjMwMzMzNzMxMzQzODM3MzI0NjM2MzU0NjM1MzgzNjQxMzI0MTM5MzIzNDQ0Mzk0MzQ0OzszNTMwMzAzMDMwO0Q5NDI5NjYxRTlBNEVBNDc5QzI2NEVCQjI0QTFEODFEOzIyQ0NEREM0NkFGNzRGNjk7NjQzMjM4MzUzOTMwMzEzOTJENjQ2NTM2NjQyRDM0Mzk2MTY2MkQzOTY0MzMzODJEMzk2MjM4MzYzOTMxNjUzMDMzMzY2NjM4Ow"

function check_main()
{
    dsware_manager_info=$(rpm -qa | grep "dsware-manager")
    originalInfo="command:rpm -qa | grep dsware-manager \n""review:${dsware_manager_info}\n"

    log INFO "${dsware_manager_info}"

    check_result_ver=$(echo "${dsware_manager_info}" | awk -F '-' '{print $3}')

    if [[ "${check_result_ver}" != V100R006C[1-3]0* ]]
    then
        log ERROR "Installation Version:${dsware_manager_info}, check result：UNOK"
        resultCode=1
        errorKey="${checkItemId}""0001"
        return 1
    fi

    #默认密码解密
    db_password=$(decrpt ${default_encrypted_password}| awk '{print}')
    ret=$?
    if [[ ${ret} -ne 0 || -z "${db_password}" ]]
    then
        log ERROR "The default password obtained by decryption is empty. Or ecryption failed ret=${ret}"
        resultCode=1
        errorKey="${checkItemId}""0002"
        originalInfo="${originalInfo}""ERROR:The default password decryption failed."
        return 1
    fi
    log INFO "get default password ok ..."

    #用默认密码登录db
    login_db_info="$(echo ${db_password} | xargs -i  su - omm -c "gsql -p 21600 -W {} -t -c 'set search_path=omm_1;'" 2>&1)"
    ret=$?
    if [[ ${ret} -ne 0 ]]
    then
        log ERROR "login db review: [${login_db_info}]; ret=${ret}"
        resultCode=1
        errorKey="${checkItemId}""0003"
        originalInfo="${originalInfo}""command:su - omm -c \\\"gsql -p 21600 -W default_db_password\\\" \n""review:${login_db_info}"
        return 1
    fi

    originalInfo="${originalInfo}""command:su - omm -c \\\"gsql -p 21600 -W default_db_password\\\" \n""result:login successfully"

    log INFO "login db with default password successfully."
    return 0
}

function main()
{
    if [[ ${tar_version} == V100R006C30SP[CH][2-5]* || ${tar_version} == V100R006C30SPC600 ]]
    then
        log INFO "Target version is ${tar_version}, begin to check ..."
        check_main
    else
        originalInfo="Target version is ${tar_version}, no need to check sub database password."
        log INFO "${originalInfo}"
    fi

    FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return "${resultCode}"
}

# --------------------------------------------------------------------------- #
#                          脚本开始运行
# --------------------------------------------------------------------------- #
log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
