#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

#输出到json文件中的checkItemId,每个检查脚本一个id
checkItemId="13"
resultCode=0
errorKey=""
params=""
originalInfo=""

#获取源版本
src_version="$(get_src_version)"

etc_passwd="/etc/passwd"

function get_src_uid()
{
    g_dsware_old_uid="$(grep "^dsware:" ${etc_passwd} |awk -F ':' '{print $3}')"
    if [ -z "${g_dsware_old_uid}" ]
    then
        error_info="user [dsware] does not exist in ${etc_passwd}"
        log ERROR "${error_info}"
        resultCode=1
        errorKey="130001"
        originalInfo="${originalInfo}""${error_info}\n"
    fi
    log INFO "g_dsware_old_uid=${g_dsware_old_uid}"

    g_omm_old_uid="$(grep "^omm:" ${etc_passwd}  |awk -F ':' '{print $3}')"
    if [ -z "${g_omm_old_uid}" ]
    then
        error_info="user [omm] does not exist in ${etc_passwd}"
        log ERROR "${error_info}"
        resultCode=1
        errorKey="130001"
        originalInfo="${originalInfo}""${error_info}\n"
    fi
    log INFO "g_omm_old_uid=${g_omm_old_uid}"

    g_ommdba_old_uid="$(grep "^ommdba:" ${etc_passwd}  |awk -F ':' '{print $3}')"
    if [ -z "${g_ommdba_old_uid}" ]
    then
        error_info="user [ommdba] does not exist in ${etc_passwd}"
        log ERROR "${error_info}"
        resultCode=1
        errorKey="130001"
        originalInfo="${originalInfo}""${error_info}\n"
    fi
    log INFO "g_ommdba_old_uid=${g_ommdba_old_uid}"

    return ${resultCode}
}

function check_main()
{
    get_src_uid || return 1

    originalInfo="command: grep dsware: ${etc_passwd} |awk -F ':' '{print \$3}'\n""${g_dsware_old_uid}\n"
    if [[ "${g_dsware_new_uid}" != "${g_dsware_old_uid}" ]]
    then
        error_info="ERROR:user [dsware] is not ${g_dsware_new_uid} in ${etc_passwd}"
        log ERROR "${error_info}"
        resultCode=1
        errorKey="130002"
        originalInfo="${originalInfo}""${error_info}\n"
    fi

    originalInfo="${originalInfo}""command: grep omm: ${etc_passwd} |awk -F ':' '{print \$3}'\n""${g_omm_old_uid}\n"
    if [[ "${g_omm_new_uid}" != "${g_omm_old_uid}" ]]
    then
        error_info="ERROR:user [omm] is not ${g_omm_new_uid} in ${etc_passwd}"
        log ERROR "${error_info}"
        resultCode=1
        errorKey="130002"
        originalInfo="${originalInfo}""${error_info}\n"
    fi

    originalInfo="${originalInfo}""command: grep ommdba: ${etc_passwd} |awk -F ':' '{print \$3}'\n""${g_ommdba_old_uid}\n"
    if [[ "${g_ommdba_new_uid}" != "${g_ommdba_old_uid}" ]]
    then
        error_info="ERROR:user [ommdba] is not ${g_ommdba_new_uid} in ${etc_passwd}"
        log ERROR "${error_info}"
        resultCode=1
        errorKey="130002"
        originalInfo="${originalInfo}""${error_info}\n"
    fi

    return 0
}

function main()
{
    if [[ ${src_version} == V100R006* || ${src_version} == V100R003C30U2* ]]
    then
        log INFO "Current version is ${src_version}, begin to check UID."
        check_main
    else
        originalInfo="Current version is ${src_version}, no need to check UID"
        log INFO "${originalInfo}"
    fi

    FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return "${resultCode}"
}

# --------------------------------------------------------------------------- #
#                          全局变量
# --------------------------------------------------------------------------- #
declare g_dsware_new_uid="2011"
declare g_omm_new_uid="2001"
declare g_ommdba_new_uid="2002"

declare g_dsware_old_uid=""
declare g_omm_old_uid=""
declare g_ommdba_old_uid=""

# --------------------------------------------------------------------------- #
#                          脚本开始运行
# --------------------------------------------------------------------------- #
log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
