#!/bin/bash

#############################################################
# 描述：根据用户指定的关键字，进行文件名匹配，把满足条件的日志
# 全部收集
#############################################################

. /opt/dsware/agent/tool/pmi/script_common.sh

start_time=$(minus_time ${1})
end_time=$(plus_time ${2})
filter_key=$3
output_dir=$4

function usage()
{
cat <<EOF
    Function: collect the specified module log
    Usage:sh Collect_match.sh {start_time} {end_time} {filter_key} {output_dir}
    start_time  : the start time, fmt must be "yyyymmddHHMM"
    end_time    : the end time, fmt must be "yyyymmddHHMM"
    filter_key  : the log file which you want to extract, support regular expression
    output_dir  : the directory for storing files
    
    For example:
    sh Collect_match.sh "201603111800" "201603112000" "log-OSD*" "/opt/dsware/agent/tool/tem"
    sh Collect_match.sh "201603111800" "201603112000" "user_vbs_meta_data*" "/opt/dsware/agent/tool/tem"
EOF
}

#检测参数个数
if [ $# -lt 4 ]
then
    usage
    myexit 1 "Param is not enough"
fi

if [ "${filter_key}" = "" ]
then
    myexit 1 "filter_key is NULL."
fi

#参数检查，目录指定，只有父进程是agent_info_collect.sh的才能使用路径：/opt/dsware/agent/tool/pmi/tmp
check_output_dir_valid $output_dir
status=$?
if [ ${status} -ne 0 ]
then
    myexit 1
fi

is_merge=0
output_dir=${output_dir}/match/${filter_key}

#先把原来的旧文件删除
if [ ! -d ${output_dir} ]
then
    mkdir -p ${output_dir}
else
    rm -rf ${output_dir}/*
fi

#新增升级评估工具与巡检工具收集结果文件
if [[ "${filter_key}" == "upgrade_precheck" || "${filter_key}" == "inspect_result" ]]
then
    tmg_file_list=($(ls /var/log/dsware/ |grep -E "${filter_key}" 2>/dev/null))
    for ((k=0;k<${#tmg_file_list[@]};k++))
    do
        if [[ -f "/var/log/dsware/${tmg_file_list[$k]}" ]]
        then
            cp -pf "/var/log/dsware/${tmg_file_list[$k]}" ${output_dir} >/dev/null 2>&1
            echo "/var/log/dsware/${tmg_file_list[$k]}"
        fi
    done
    myexit 0
fi

#先从tar包中解压指定的文件
output_trace "INFO" "Begin to find log from tar.gz file, filter_key=${filter_key}"
sh /opt/dsware/agent/tool/pmi/infoCollect/extract_log.sh ${start_time} ${end_time} "${filter_key}" ${is_merge} ${output_dir} > /dev/null 2>&1
status=$?

if [ ${status} -eq 0 ]
then
    #如果tar包中找到符合条件的日志，输出文件列表，待下一步打包
    tar_file_list=($(find ${output_dir} -size +0 -name "*${filter_key}*" 2>/dev/null))
    echo ${tar_file_list[@]}
elif [ ${status} -eq 1 ]
then
    #如果tar包中没有找到日志，记录下来
    output_trace "INFO" "There isn't log"
else
    myexit 1
fi


#不管有没有从tar包中找到，还要在最新日志中找，但是，当前日志要在指定区间内
output_trace "INFO" "Begin to find log from current env which still not compressed, filter_key=${filter_key}"
tmg_file_list=($(ls /var/log/dsware/ |grep -E "${filter_key}" 2>/dev/null))
for ((k=0;k<${#tmg_file_list[@]};k++))
do
    if [ -f "/var/log/dsware/${tmg_file_list[$k]}" ]
    then
        check_file_is_should_collect "/var/log/dsware/${tmg_file_list[$k]}" ${start_time} ${end_time}
        status=$?

        [ ${status} -eq 0 ] && cp -pf "/var/log/dsware/${tmg_file_list[$k]}" ${output_dir} >/dev/null 2>&1
        [ ${status} -eq 0 ] && echo "/var/log/dsware/${tmg_file_list[$k]}"

    fi
done

#从以下/var/log/omm/*目录下查找文件
fileList=$(timeout 30 find /var/log/ -size -100M -name "*${filter_key}*" 2>/dev/null)
[[ $? -eq 124 ]] && myexit 1
fileArray=($fileList)
for ((i=0;i<${#fileArray[@]};i++))
do
    if [ -f ${fileArray[$i]} ]; then
        fileTime="$(stat -c "%y" ${fileArray[$i]} | awk '{print $1$2}' |awk -F- '{print $1$2$3}' | awk -F: '{print $1$2}')"
        if is_in_time $fileTime ${start_time} ${end_time}; then
            cp -pf "${fileArray[$i]}" "${output_dir}" >/dev/null 2>&1
            echo "${fileArray[$i]}"
        fi
    fi
done

myexit 0

